/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.compat.jei;

import com.hermitowo.advancedtfctech.AdvancedTFCTech;
import com.hermitowo.advancedtfctech.common.multiblocks.logic.ATTMultiblockLogic;
import com.hermitowo.advancedtfctech.common.recipes.BeamhouseRecipe;
import com.hermitowo.advancedtfctech.common.recipes.outputs.DoubleIfMachineMadeModifier;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.compat.jei.category.BaseRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class BeamhouseRecipeCategory
extends BaseRecipeCategory<BeamhouseRecipe> {
    private static final ResourceLocation ICONS = AdvancedTFCTech.rl("textures/gui/jei/jei.png");
    private final IDrawableStatic slot;
    private final IDrawableStatic arrows;
    private final IDrawableAnimated arrowsAnimated;

    public BeamhouseRecipeCategory(RecipeType<BeamhouseRecipe> type, IGuiHelper helper) {
        super(type, helper, 98, 26, ATTMultiblockLogic.BEAMHOUSE.iconStack());
        this.arrows = helper.createDrawable(ICONS, 0, 118, 22, 16);
        IDrawableStatic arrowAnimated = helper.createDrawable(ICONS, 22, 118, 22, 16);
        this.arrowsAnimated = helper.createAnimatedDrawable(arrowAnimated, 80, IDrawableAnimated.StartDirection.LEFT, false);
        this.slot = helper.getSlotDrawable();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BeamhouseRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder fluidInput = builder.addSlot(RecipeIngredientRole.INPUT, 6, 5);
        IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, 26, 5);
        IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 5);
        fluidInput.addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, Arrays.asList(recipe.fluidInput.getFluids()));
        input.addItemStacks(recipe.input.getMatchingStackList());
        output.addItemStacks(BeamhouseRecipeCategory.collapse((List)recipe.input.getMatchingStackList(), (ItemStackProvider)recipe.output));
        fluidInput.setBackground((IDrawable)this.slot, -1, -1);
        input.setBackground((IDrawable)this.slot, -1, -1);
        output.setBackground((IDrawable)this.slot, -1, -1);
        fluidInput.setFluidRenderer(1L, false, 16, 16);
        if (recipe.output.modifiers().stream().anyMatch(modifier -> modifier.getClass().equals(DoubleIfMachineMadeModifier.class))) {
            output.addRichTooltipCallback((slots, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)"advancedtfctech.jei.double_if_has_tag").withStyle(ChatFormatting.ITALIC)));
        }
    }

    public void draw(BeamhouseRecipe recipe, IRecipeSlotsView recipeSlots, GuiGraphics graphics, double mouseX, double mouseY) {
        this.arrows.draw(graphics, 48, 5);
        this.arrowsAnimated.draw(graphics, 48, 5);
    }
}

