/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.config;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.hermitowo.advancedtfctech.common.recipes.BeamhouseRecipe;
import com.hermitowo.advancedtfctech.common.recipes.GristMillRecipe;
import com.hermitowo.advancedtfctech.common.recipes.PowerLoomRecipe;
import com.hermitowo.advancedtfctech.common.recipes.ThresherRecipe;
import com.hermitowo.advancedtfctech.config.ConfigBuilder;
import java.util.function.Supplier;
import net.dries007.tfc.config.BaseConfig;

public class ATTServerConfig
extends BaseConfig {
    public final MultiblockRecipe.RecipeMultiplier thresherConfig;
    public final MultiblockRecipe.RecipeMultiplier gristMillConfig;
    public final MultiblockRecipe.RecipeMultiplier powerLoomConfig;
    public final MultiblockRecipe.RecipeMultiplier beamhouseConfig;
    public final Supplier<Integer> fleshingMachine_bladesDamage;
    public final Supplier<Boolean> enablePowerLoomDebug;
    public final Supplier<Boolean> enableFleshingMachineDebug;

    ATTServerConfig(ConfigBuilder builder) {
        builder.push("general");
        this.thresherConfig = this.addMachineEnergyTimeModifiers(builder, "thresher");
        this.gristMillConfig = this.addMachineEnergyTimeModifiers(builder, "grist mill");
        this.powerLoomConfig = this.addMachineEnergyTimeModifiers(builder, "power loom");
        this.beamhouseConfig = this.addMachineEnergyTimeModifiers(builder, "beamhouse");
        this.fleshingMachine_bladesDamage = builder.comment("The maximum amount of damage Fleshing Blades can take. While the fleshing machine is working, the blades sustain 1 damage per tick, so this is effectively the lifetime in ticks.").define("fleshingMachine_bladesDamage", 20000, 1, Integer.MAX_VALUE);
        builder.swap("debug");
        this.enablePowerLoomDebug = builder.comment("If true, a GUI can be opened up by rightclicking the Power Loom with a Pirn.").define("enablePowerLoomDebug", false);
        this.enableFleshingMachineDebug = builder.comment("If true, a GUI can be opened up by rightclicking the Fleshing Machine.").define("enableFleshingMachineDebug", false);
        builder.pop();
    }

    public void populateAPI() {
        ThresherRecipe.MULTIPLIERS.setValue(this.thresherConfig);
        GristMillRecipe.MULTIPLIERS.setValue(this.gristMillConfig);
        PowerLoomRecipe.MULTIPLIERS.setValue(this.powerLoomConfig);
        BeamhouseRecipe.MULTIPLIERS.setValue(this.beamhouseConfig);
    }

    private MultiblockRecipe.RecipeMultiplier addMachineEnergyTimeModifiers(ConfigBuilder builder, String machine) {
        return this.addMachineEnergyTimeModifiers(builder, machine, true);
    }

    private MultiblockRecipe.RecipeMultiplier addMachineEnergyTimeModifiers(ConfigBuilder builder, String machine, boolean popCategory) {
        builder.push(machine.replace(' ', '_'));
        Supplier<Double> energy = builder.comment("A modifier to apply to the energy costs of every " + machine + " recipe").define("energyModifier", 1.0, 0.001, 1000.0);
        Supplier<Double> time = builder.comment("A modifier to apply to the time of every " + machine + " recipe").define("timeModifier", 1.0, 0.001, 1000.0);
        if (popCategory) {
            builder.pop();
        }
        return new MultiblockRecipe.RecipeMultiplier(energy::get, time::get);
    }
}

