/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.config;

import com.hermitowo.advancedtfctech.config.ATTConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigBuilder {
    private final ModConfigSpec.Builder builder;
    private final Factory factory;
    private final String translationKeyPrefix;
    private boolean emptyLineAdded;

    public ConfigBuilder(ModConfigSpec.Builder builder, Factory factory, String translationKeyPrefix) {
        this.builder = builder;
        this.factory = factory;
        this.translationKeyPrefix = translationKeyPrefix;
        this.emptyLineAdded = false;
    }

    public ConfigBuilder push(String path) {
        this.builder.push(path);
        return this;
    }

    public ConfigBuilder swap(String path) {
        this.builder.pop().push(path);
        return this;
    }

    public ConfigBuilder pop() {
        this.builder.pop();
        return this;
    }

    public ConfigBuilder pop(int n) {
        for (int i = 0; i < n; ++i) {
            this.pop();
        }
        return this;
    }

    public ConfigBuilder comment(String ... text) {
        if (!this.emptyLineAdded) {
            this.builder.comment("");
            this.emptyLineAdded = true;
        }
        for (String line : text) {
            this.builder.comment(" " + line);
        }
        return this;
    }

    public Supplier<Boolean> define(String path, boolean value) {
        return this.factory.create(this.begin(path).define(path, value));
    }

    public Supplier<Integer> define(String path, int value, int min, int max) {
        return this.factory.create(this.begin(path).defineInRange(path, value, min, max));
    }

    public Supplier<Integer> define(String path, int value) {
        return this.factory.create(this.begin(path).define(path, (Object)value));
    }

    public Supplier<Double> define(String path, double value, double min, double max) {
        return this.factory.create(this.begin(path).defineInRange(path, value, min, max));
    }

    public Supplier<String> define(String path, String value) {
        return this.factory.create(this.begin(path).define(path, (Object)value));
    }

    public <E extends Enum<E>> Supplier<E> define(String path, E value) {
        return this.factory.create(this.begin(path).defineEnum(path, value));
    }

    public Supplier<List<String>> define(String path, List<String> value, Predicate<String> predicate) {
        return this.factory.create(this.begin(path).defineListAllowEmpty(path, new ArrayList<String>(value), String::new, o -> {
            String s;
            return o instanceof String && predicate.test(s = (String)o);
        }));
    }

    public Supplier<List<List<String>>> defineListOfList(String path, List<List<String>> value) {
        return this.factory.create(this.begin(path).defineListAllowEmpty(path, new ArrayList<List<String>>(value), ArrayList::new, o -> true));
    }

    private ModConfigSpec.Builder begin(String path) {
        this.builder.translation("advancedtfctech.config." + this.translationKeyPrefix + "." + path);
        this.emptyLineAdded = false;
        return this.builder;
    }

    static interface Factory {
        public <T, V extends ModConfigSpec.ConfigValue<T>> Supplier<T> create(V var1);
    }

    record ServerValue<T>(ModConfigSpec.ConfigValue<T> value) implements Supplier<T>
    {
        @Override
        public T get() {
            return (T)(ATTConfig.SERVER.spec().isLoaded() ? this.value.get() : this.value.getDefault());
        }
    }

    record ClientValue<T>(ModConfigSpec.ConfigValue<T> value) implements Supplier<T>
    {
        @Override
        public T get() {
            return (T)(ATTConfig.CLIENT.spec().isLoaded() ? this.value.get() : this.value.getDefault());
        }
    }
}

