/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.advancedtfctech.util;

import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import javax.annotation.Nonnull;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public class FluidHelper {
    public static boolean interactWithFluidHandler(Player player, InteractionHand hand, final IFluidHandler handler, boolean canExtract) {
        MutableObject lastNonSimulated = new MutableObject();
        MutableBoolean isInsert = new MutableBoolean();
        FluidUtils.WrapperFluidHandler simulationWrapper = new FluidUtils.WrapperFluidHandler(handler, (Mutable)lastNonSimulated, isInsert){
            final /* synthetic */ Mutable val$lastNonSimulated;
            final /* synthetic */ MutableBoolean val$isInsert;
            {
                this.val$lastNonSimulated = mutable;
                this.val$isInsert = mutableBoolean;
                super(arg0);
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                int result = handler.fill(resource, IFluidHandler.FluidAction.SIMULATE);
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.val$lastNonSimulated.setValue((Object)resource.copyWithAmount(result));
                    this.val$isInsert.setTrue();
                }
                return result;
            }

            @Nonnull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                FluidStack result = handler.drain(resource, IFluidHandler.FluidAction.SIMULATE);
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.val$isInsert.setFalse();
                    this.val$lastNonSimulated.setValue((Object)result.copy());
                }
                return result;
            }

            @Nonnull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                FluidStack result = handler.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE);
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.val$isInsert.setFalse();
                    this.val$lastNonSimulated.setValue((Object)result.copy());
                }
                return result;
            }
        };
        boolean success = FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)simulationWrapper);
        if (success) {
            if (isInsert.booleanValue()) {
                handler.fill((FluidStack)lastNonSimulated.getValue(), IFluidHandler.FluidAction.EXECUTE);
            } else if (canExtract) {
                handler.drain((FluidStack)lastNonSimulated.getValue(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        return success;
    }

    public static boolean drainFluidContainer(IItemHandlerModifiable inventory, FluidTank tank, int inputSlot, int outputSlot) {
        int amountPrev = tank.getFluidAmount();
        ItemStack outputStack = inventory.getStackInSlot(outputSlot);
        ItemStack emptyContainer = FluidHelper.drainFluidContainer((IFluidHandler)tank, inventory.getStackInSlot(inputSlot), outputStack);
        if (amountPrev != tank.getFluidAmount()) {
            if (ItemStack.isSameItemSameComponents((ItemStack)outputStack, (ItemStack)emptyContainer)) {
                outputStack.grow(emptyContainer.getCount());
            } else if (outputStack.isEmpty()) {
                inventory.setStackInSlot(outputSlot, emptyContainer.copy());
            }
            inventory.getStackInSlot(inputSlot).shrink(outputSlot);
            return true;
        }
        return false;
    }

    public static ItemStack drainFluidContainer(IFluidHandler handler, ItemStack containerIn, ItemStack containerOut) {
        FluidActionResult result = FluidUtils.tryEmptyContainer((ItemStack)containerIn, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (IFluidHandler.FluidAction)IFluidHandler.FluidAction.SIMULATE);
        if (result.isSuccess()) {
            ItemStack empty = result.getResult();
            if (containerOut.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)containerOut, (ItemStack)empty)) {
                if (!containerOut.isEmpty() && containerOut.getCount() + empty.getCount() > containerOut.getMaxStackSize()) {
                    return ItemStack.EMPTY;
                }
                result = FluidUtils.tryEmptyContainer((ItemStack)containerIn, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (IFluidHandler.FluidAction)IFluidHandler.FluidAction.EXECUTE);
                if (result.isSuccess()) {
                    return result.getResult();
                }
            }
        }
        return ItemStack.EMPTY;
    }
}

