/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.storageboxadapter.block;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.pitan76.mcpitanlib.api.block.ExtendBlockEntityProvider;
import net.pitan76.mcpitanlib.api.block.v2.CompatBlock;
import net.pitan76.mcpitanlib.api.block.v2.CompatibleBlockSettings;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.block.BlockUseEvent;
import net.pitan76.mcpitanlib.api.event.block.ItemScattererUtil;
import net.pitan76.mcpitanlib.api.event.block.StateReplacedEvent;
import net.pitan76.mcpitanlib.api.event.block.TileCreateEvent;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.midohra.util.math.BlockPos;
import net.pitan76.mcpitanlib.midohra.world.World;
import net.pitan76.storageboxadapter.block.AdapterBlockEntity;
import net.pitan76.storageboxadapter.block.BlockEntities;
import org.jetbrains.annotations.Nullable;

public class AdapterBlock
extends CompatBlock
implements ExtendBlockEntityProvider {
    public AdapterBlock(CompatibleBlockSettings settings) {
        super(settings);
    }

    public CompatActionResult onRightClick(BlockUseEvent e) {
        if (e.isSneaking()) {
            return super.onRightClick(e);
        }
        if (e.isClient()) {
            return e.success();
        }
        Player player = e.getPlayer();
        class_2586 blockEntity = e.getBlockEntity();
        if (!(blockEntity instanceof AdapterBlockEntity)) {
            return e.success();
        }
        AdapterBlockEntity adapterBlockEntity = (AdapterBlockEntity)blockEntity;
        player.openExtendedMenu((ExtendedMenuProvider)adapterBlockEntity);
        return e.success();
    }

    public void onStateReplaced(StateReplacedEvent e) {
        World world = e.getMidohraWorld();
        BlockPos pos = e.getMidohraPos();
        if (e.isSameState()) {
            return;
        }
        class_2586 blockEntity = e.getBlockEntity();
        if (blockEntity instanceof AdapterBlockEntity) {
            AdapterBlockEntity adapter = (AdapterBlockEntity)blockEntity;
            ItemScattererUtil.spawn((World)world, (BlockPos)pos, (class_2371)adapter.inv);
            e.updateComparators();
        }
        super.onStateReplaced(e);
    }

    @Nullable
    public class_2586 createBlockEntity(TileCreateEvent e) {
        return new AdapterBlockEntity(e);
    }

    @Nullable
    public <T extends class_2586> class_2591<T> getBlockEntityType() {
        return (class_2591)BlockEntities.ADAPTER.getOrNull();
    }

    public boolean isTick() {
        return true;
    }
}

