/*
 * Decompiled with CFR 0.152.
 */
package ru.berdinskiybear.armorhud;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4061;
import net.minecraft.class_768;
import net.uku3lig.ukulib.config.ConfigManager;
import net.uku3lig.ukulib.utils.Ukutils;
import org.jetbrains.annotations.Nullable;
import ru.berdinskiybear.armorhud.config.ArmorHudConfig;

public final class ArmorHudMod
implements ClientModInitializer {
    private static final ConfigManager<ArmorHudConfig> manager = ConfigManager.createDefault(ArmorHudConfig.class, (String)"ukus-armor-hud");
    public static final int STEP = 20;
    public static final int WIDTH = 22;
    public static final int HEIGHT = 22;
    public static final int HOTBAR_OFFSET = 98;
    public static final int OFFHAND_OFFSET = 29;
    public static final int ATTACK_INDICATOR_OFFSET = 23;
    public static final int WARNING_OFFSET = 7;
    public static final List<Integer> ARMOR_SLOTS = Stream.of(class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166).map(s -> s.method_32320(36)).toList();

    @Nullable
    public static class_1657 getCameraPlayer() {
        class_1657 player;
        class_1297 class_12972 = class_310.method_1551().method_1560();
        return class_12972 instanceof class_1657 ? (player = (class_1657)class_12972) : null;
    }

    public static Optional<class_768> getWidgetRect(class_332 context, class_1657 player) {
        int sideOffsetMultiplier;
        int sideMultiplier;
        ArmorHudConfig config = (ArmorHudConfig)manager.getConfig();
        List<class_1799> armorItems = ArmorHudMod.getArmorItems(player);
        if (armorItems.isEmpty()) {
            return Optional.empty();
        }
        if (config.getAnchor() == ArmorHudConfig.Anchor.HOTBAR && config.getSide() == class_1306.field_6182 || config.getAnchor() != ArmorHudConfig.Anchor.HOTBAR && config.getSide() == class_1306.field_6183) {
            sideMultiplier = -1;
            sideOffsetMultiplier = -1;
        } else {
            sideMultiplier = 1;
            sideOffsetMultiplier = 0;
        }
        int verticalMultiplier = switch (config.getAnchor()) {
            default -> throw new MatchException(null, null);
            case ArmorHudConfig.Anchor.TOP, ArmorHudConfig.Anchor.TOP_CENTER -> 1;
            case ArmorHudConfig.Anchor.BOTTOM, ArmorHudConfig.Anchor.HOTBAR -> -1;
        };
        int addedHotbarOffset = switch (config.getOffhandSlotBehavior()) {
            default -> throw new MatchException(null, null);
            case ArmorHudConfig.OffhandSlotBehavior.ALWAYS_IGNORE -> 0;
            case ArmorHudConfig.OffhandSlotBehavior.ALWAYS_LEAVE_SPACE -> Math.max(29, 23);
            case ArmorHudConfig.OffhandSlotBehavior.ADHERE -> {
                if (player.method_6068().method_5928() == config.getSide()) {
                    if (!player.method_6079().method_7960()) {
                        yield 29;
                    }
                    if (class_310.method_1551().field_1690.method_42565().method_41753() == class_4061.field_18153) {
                        yield 23;
                    }
                }
                yield 0;
            }
        };
        int textureWidth = 22 + (armorItems.size() - 1) * 20;
        int widgetWidth = config.getOrientation() == ArmorHudConfig.Orientation.VERTICAL ? 22 : textureWidth;
        int widgetHeight = config.getOrientation() == ArmorHudConfig.Orientation.VERTICAL ? textureWidth : 22;
        int n = config.getOffsetX() * sideMultiplier;
        int armorWidgetX = n + (switch (config.getAnchor()) {
            default -> throw new MatchException(null, null);
            case ArmorHudConfig.Anchor.TOP_CENTER -> context.method_51421() / 2 - widgetWidth / 2;
            case ArmorHudConfig.Anchor.TOP, ArmorHudConfig.Anchor.BOTTOM -> (widgetWidth - context.method_51421()) * sideOffsetMultiplier;
            case ArmorHudConfig.Anchor.HOTBAR -> context.method_51421() / 2 + (98 + addedHotbarOffset) * sideMultiplier + widgetWidth * sideOffsetMultiplier;
        });
        int n2 = config.getOffsetY() * verticalMultiplier;
        int armorWidgetY = n2 + (switch (config.getAnchor()) {
            default -> throw new MatchException(null, null);
            case ArmorHudConfig.Anchor.BOTTOM, ArmorHudConfig.Anchor.HOTBAR -> context.method_51443() - widgetHeight;
            case ArmorHudConfig.Anchor.TOP, ArmorHudConfig.Anchor.TOP_CENTER -> 0;
        });
        return Optional.of(new class_768(armorWidgetX, armorWidgetY, widgetWidth, widgetHeight));
    }

    public static List<class_1799> getArmorItems(class_1657 player) {
        Stream<class_1799> items = ARMOR_SLOTS.stream().map(i -> player.method_31548().method_5438(i.intValue()));
        items = switch (((ArmorHudConfig)manager.getConfig()).getWidgetShown()) {
            default -> throw new MatchException(null, null);
            case ArmorHudConfig.WidgetShown.ALWAYS, ArmorHudConfig.WidgetShown.IF_ANY_PRESENT -> items;
            case ArmorHudConfig.WidgetShown.NOT_EMPTY -> items.filter(s -> !s.method_7960());
            case ArmorHudConfig.WidgetShown.DAMAGED_PIECES -> items.filter(ArmorHudMod::shouldShowWarning);
        };
        List<class_1799> itemList = items.toList();
        if (((ArmorHudConfig)manager.getConfig()).getWidgetShown() == ArmorHudConfig.WidgetShown.IF_ANY_PRESENT && itemList.stream().allMatch(class_1799::method_7960)) {
            return Collections.emptyList();
        }
        return itemList;
    }

    public static boolean shouldShowWarning(class_1799 stack) {
        int maxDamage;
        if (stack.method_7960() || !stack.method_7963()) {
            return false;
        }
        int damage = stack.method_7919();
        double percentage = 1.0 - (double)damage / (double)(maxDamage = stack.method_7936());
        return percentage <= ((ArmorHudConfig)manager.getConfig()).getMinDurabilityPercentage() || maxDamage - damage <= ((ArmorHudConfig)manager.getConfig()).getMinDurabilityValue();
    }

    public void onInitializeClient() {
        Ukutils.registerToggleBind((class_304)new class_304("armorhud.keybind.toggle", -1, class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"ukus-armor-hud", (String)"key"))), () -> ((ArmorHudConfig)manager.getConfig()).isEnabled(), b -> ((ArmorHudConfig)manager.getConfig()).setEnabled(b), (class_2561)class_2561.method_43471((String)"armorhud.keybind.toggle.msg"));
    }

    @Generated
    public static ConfigManager<ArmorHudConfig> getManager() {
        return manager;
    }
}

