/*
 * Decompiled with CFR 0.152.
 */
package ru.berdinskiybear.armorhud.mixin;

import java.util.Optional;
import java.util.SequencedCollection;
import net.minecraft.class_10209;
import net.minecraft.class_10799;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_5819;
import net.minecraft.class_768;
import net.minecraft.class_9779;
import org.joml.Math;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ru.berdinskiybear.armorhud.ArmorHudMod;
import ru.berdinskiybear.armorhud.config.ArmorHudConfig;

@Mixin(value={class_329.class})
public abstract class InGameHudMixin {
    @Shadow
    @Final
    private class_5819 field_2034;
    @Unique
    private static final class_2960 WARNING_TEXTURE = class_2960.method_60655((String)"ukus-armor-hud", (String)"warn.png");
    @Unique
    private int shift = 0;

    @Shadow
    protected abstract void method_1762(class_332 var1, int var2, int var3, class_9779 var4, class_1657 var5, class_1799 var6, int var7);

    @Inject(method={"renderHotbar"}, at={@At(value="TAIL")})
    public void renderArmorHud(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        class_10209.method_64146().method_15396("ukus-armor-hud");
        this.drawArmorHud(context, tickCounter);
        class_10209.method_64146().method_15407();
    }

    @Unique
    private void drawArmorHud(class_332 context, class_9779 tickCounter) {
        ArmorHudConfig config = (ArmorHudConfig)ArmorHudMod.getManager().getConfig();
        if (!config.isEnabled()) {
            return;
        }
        class_1657 player = ArmorHudMod.getCameraPlayer();
        if (player == null) {
            return;
        }
        Optional<class_768> rect = ArmorHudMod.getWidgetRect(context, player);
        if (rect.isEmpty()) {
            return;
        }
        SequencedCollection<Object> armorItems = ArmorHudMod.getArmorItems(player);
        if (config.isReversed()) {
            armorItems = armorItems.reversed();
        }
        int textureWidth = 22 + (armorItems.size() - 1) * 20;
        context.method_51448().pushMatrix();
        context.method_51448().translate((float)rect.get().method_3321(), (float)rect.get().method_3322());
        if (config.getOrientation() == ArmorHudConfig.Orientation.VERTICAL) {
            context.method_51448().rotate(Math.toRadians((float)90.0f)).translate(0.0f, -22.0f);
        }
        switch (config.getStyle()) {
            case HOTBAR: {
                context.method_70846(class_10799.field_56883, class_329.field_45310, 182, 22, 0, 0, 0, 0, textureWidth - 3, 22);
                context.method_70846(class_10799.field_56883, class_329.field_45310, 182, 22, 179, 0, textureWidth - 3, 0, 3, 22);
                break;
            }
            case ROUNDED_CORNERS: {
                context.method_70846(class_10799.field_56883, class_329.field_45312, 29, 24, 0, 1, 0, 0, 3, 22);
                context.method_70846(class_10799.field_56883, class_329.field_45310, 182, 22, 3, 0, 3, 0, textureWidth - 6, 22);
                context.method_70846(class_10799.field_56883, class_329.field_45312, 29, 24, 19, 1, textureWidth - 3, 0, 3, 22);
                break;
            }
            case ROUNDED: {
                int borderWidth = 1;
                context.method_70846(class_10799.field_56883, class_329.field_45312, 29, 24, 0, 1, 0, 0, borderWidth, 22);
                for (int i = 0; i < armorItems.size(); ++i) {
                    context.method_70846(class_10799.field_56883, class_329.field_45312, 29, 24, borderWidth, 1, borderWidth + i * 20, 0, 20, 22);
                }
                context.method_70846(class_10799.field_56883, class_329.field_45312, 29, 24, 0, 1, textureWidth - borderWidth, 0, borderWidth, 22);
                break;
            }
        }
        context.method_51448().popMatrix();
        for (int i = 0; i < armorItems.size(); ++i) {
            class_1799 stack = (class_1799)armorItems.get(i);
            int slotX = rect.get().method_3321();
            int slotY = rect.get().method_3322();
            switch (config.getOrientation()) {
                case HORIZONTAL: {
                    slotX += 20 * i;
                    break;
                }
                case VERTICAL: {
                    slotY += 20 * i;
                }
            }
            if (config.isIconsShown() && config.getWidgetShown().shouldDrawEmptySlots() && stack.method_7960()) {
                int slotIndex = config.isReversed() ? 3 - i : i;
                class_2960 identifier = (class_2960)class_1723.field_7829.get(class_1723.field_7832[slotIndex]);
                context.method_52706(class_10799.field_56883, identifier, slotX + 3, slotY + 3, 16, 16);
            }
            this.method_1762(context, slotX + 3, slotY + 3, tickCounter, player, stack, i + 1);
            if (!config.isWarningShown() || !ArmorHudMod.shouldShowWarning(stack)) continue;
            int x = slotX;
            int y = slotY;
            switch (config.getOrientation()) {
                case HORIZONTAL: {
                    int verticalOffsetMultiplier = switch (config.getAnchor()) {
                        default -> throw new MatchException(null, null);
                        case ArmorHudConfig.Anchor.TOP, ArmorHudConfig.Anchor.TOP_CENTER -> 0;
                        case ArmorHudConfig.Anchor.BOTTOM, ArmorHudConfig.Anchor.HOTBAR -> -1;
                    };
                    x += 7;
                    y += 22 * (verticalOffsetMultiplier + 1) + 8 * verticalOffsetMultiplier;
                    break;
                }
                case VERTICAL: {
                    class_1306 warningSide = config.getAnchor() == ArmorHudConfig.Anchor.HOTBAR ? config.getSide().method_5928() : config.getSide();
                    int horizontalOffsetMultiplier = switch (warningSide) {
                        default -> throw new MatchException(null, null);
                        case class_1306.field_6182 -> 0;
                        case class_1306.field_6183 -> -1;
                    };
                    x += 22 * (horizontalOffsetMultiplier + 1) + 8 * horizontalOffsetMultiplier;
                    y += 7;
                }
            }
            if (config.getWarningBobIntensity() != 0) {
                int intensity = config.getWarningBobIntensity();
                y += (int)((double)this.field_2034.method_43048(intensity) - java.lang.Math.ceil((float)intensity / 2.0f));
            }
            context.method_25290(class_10799.field_56883, WARNING_TEXTURE, x, y, 0.0f, 0.0f, 8, 8, 8, 8);
        }
    }

    @Inject(method={"renderStatusEffectOverlay"}, at={@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;")})
    public void calculateStatusEffectIconsOffset(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        this.shift = 0;
        ArmorHudConfig config = (ArmorHudConfig)ArmorHudMod.getManager().getConfig();
        if (!config.isEnabled() || !config.isPushStatusEffectIcons() || config.getAnchor() != ArmorHudConfig.Anchor.TOP || config.getSide() != class_1306.field_6183) {
            return;
        }
        class_1657 player = ArmorHudMod.getCameraPlayer();
        if (player == null) {
            return;
        }
        Optional<class_768> rect = ArmorHudMod.getWidgetRect(context, player);
        if (rect.isEmpty()) {
            return;
        }
        int newShift = rect.get().method_3322() + rect.get().method_3320();
        if (config.isWarningShown() && config.getOrientation() == ArmorHudConfig.Orientation.HORIZONTAL) {
            newShift += 10 + config.getWarningBobIntensity();
        }
        this.shift = java.lang.Math.max(newShift, 0);
    }

    @ModifyVariable(method={"renderStatusEffectOverlay"}, at=@At(value="STORE"), ordinal=3)
    public int statusEffectIconsOffset(int y) {
        return y + this.shift;
    }
}

