/*
 * Decompiled with CFR 0.152.
 */
package ru.berdinskiybear.armorhud.mixin;

import java.util.Objects;
import java.util.Optional;
import java.util.SequencedCollection;
import net.minecraft.class_10209;
import net.minecraft.class_10799;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_5819;
import net.minecraft.class_768;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import org.joml.Math;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ru.berdinskiybear.armorhud.ArmorHudMod;
import ru.berdinskiybear.armorhud.config.ArmorHudConfig;

@Mixin(value={class_329.class})
public abstract class InGameHudMixin {
    @Shadow
    @Final
    private class_5819 field_2034;
    @Unique
    private static final class_2960 WARNING_TEXTURE = class_2960.method_60655((String)"ukus-armor-hud", (String)"warn.png");
    @Unique
    private int shift = 0;

    @Shadow
    protected abstract void method_1762(class_332 var1, int var2, int var3, class_9779 var4, class_1657 var5, class_1799 var6, int var7);

    @Shadow
    public abstract class_327 method_1756();

    @Inject(method={"renderHotbar"}, at={@At(value="TAIL")})
    public void renderArmorHud(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        class_10209.method_64146().method_15396("ukus-armor-hud");
        this.drawArmorHud(context, tickCounter);
        class_10209.method_64146().method_15407();
    }

    @Unique
    private void drawArmorHud(class_332 context, class_9779 tickCounter) {
        ArmorHudConfig config = (ArmorHudConfig)ArmorHudMod.getManager().getConfig();
        if (!config.isEnabled()) {
            return;
        }
        class_1657 player = ArmorHudMod.getCameraPlayer();
        if (player == null) {
            return;
        }
        Optional<class_768> rect = ArmorHudMod.getWidgetRect(context, player);
        if (rect.isEmpty()) {
            return;
        }
        SequencedCollection<Object> armorItems = ArmorHudMod.getArmorItems(player);
        if (config.isReversed()) {
            armorItems = armorItems.reversed();
        }
        int textureWidth = 22 + (armorItems.size() - 1) * 20;
        context.method_51448().pushMatrix();
        context.method_51448().translate((float)rect.get().method_3321(), (float)rect.get().method_3322());
        if (config.getOrientation() == ArmorHudConfig.Orientation.VERTICAL) {
            context.method_51448().rotate(Math.toRadians((float)90.0f)).translate(0.0f, -22.0f);
        }
        switch (config.getStyle()) {
            case HOTBAR: {
                context.method_70846(class_10799.field_56883, class_329.field_45310, 182, 22, 0, 0, 0, 0, textureWidth - 3, 22);
                context.method_70846(class_10799.field_56883, class_329.field_45310, 182, 22, 179, 0, textureWidth - 3, 0, 3, 22);
                break;
            }
            case ROUNDED_CORNERS: {
                context.method_70846(class_10799.field_56883, class_329.field_45312, 29, 24, 0, 1, 0, 0, 3, 22);
                context.method_70846(class_10799.field_56883, class_329.field_45310, 182, 22, 3, 0, 3, 0, textureWidth - 6, 22);
                context.method_70846(class_10799.field_56883, class_329.field_45312, 29, 24, 19, 1, textureWidth - 3, 0, 3, 22);
                break;
            }
            case ROUNDED: {
                int borderWidth = 1;
                context.method_70846(class_10799.field_56883, class_329.field_45312, 29, 24, 0, 1, 0, 0, borderWidth, 22);
                for (int i = 0; i < armorItems.size(); ++i) {
                    context.method_70846(class_10799.field_56883, class_329.field_45312, 29, 24, borderWidth, 1, borderWidth + i * 20, 0, 20, 22);
                }
                context.method_70846(class_10799.field_56883, class_329.field_45312, 29, 24, 0, 1, textureWidth - borderWidth, 0, borderWidth, 22);
                break;
            }
        }
        context.method_51448().popMatrix();
        for (int i = 0; i < armorItems.size(); ++i) {
            class_1306 extrasSide;
            class_1799 stack = (class_1799)armorItems.get(i);
            int x = rect.get().method_3321();
            int y = rect.get().method_3322();
            switch (config.getOrientation()) {
                case HORIZONTAL: {
                    x += 20 * i;
                    break;
                }
                case VERTICAL: {
                    y += 20 * i;
                }
            }
            if (config.isIconsShown() && config.getWidgetShown().shouldDrawEmptySlots() && stack.method_7960()) {
                int slotIndex = config.isReversed() ? 3 - i : i;
                class_2960 identifier = (class_2960)class_1723.field_7829.get(class_1723.field_7832[slotIndex]);
                context.method_52706(class_10799.field_56883, identifier, x + 3, y + 3, 16, 16);
            }
            this.method_1762(context, x + 3, y + 3, tickCounter, player, stack, i + 1);
            class_1306 class_13062 = extrasSide = config.getAnchor() == ArmorHudConfig.Anchor.HOTBAR ? config.getSide() : config.getSide().method_5928();
            if (config.getAnchor().isTop() && config.getOrientation() == ArmorHudConfig.Orientation.HORIZONTAL) {
                y += 22;
            } else if (extrasSide == class_1306.field_6183 && config.getOrientation() == ArmorHudConfig.Orientation.VERTICAL) {
                x += 22;
            }
            if (config.getDurabilityDisplay() == ArmorHudConfig.DurabilityDisplay.NUMERIC) {
                String dura = String.valueOf(stack.method_7936() - stack.method_7919());
                Objects.requireNonNull(this.method_1756());
                int textHeight = 9;
                if (config.getOrientation() == ArmorHudConfig.Orientation.HORIZONTAL) {
                    if (!config.getAnchor().isTop()) {
                        y -= textHeight;
                    }
                    context.method_25300(this.method_1756(), dura, x + 11, y, class_9848.method_61334((int)stack.method_31580()));
                    if (config.getAnchor().isTop()) {
                        y += textHeight;
                    }
                } else {
                    int textWidth = this.method_1756().method_1727(dura) + 2;
                    int textY = (22 - textHeight) / 2;
                    if (extrasSide == class_1306.field_6182) {
                        x -= textWidth;
                    }
                    context.method_25303(this.method_1756(), dura, x + 1, y + textY, class_9848.method_61334((int)stack.method_31580()));
                    if (extrasSide == class_1306.field_6183) {
                        x += textWidth;
                    }
                }
            }
            if (!config.isWarningShown() || !ArmorHudMod.shouldShowWarning(stack)) continue;
            if (config.getWarningBobIntensity() != 0) {
                int intensity = config.getWarningBobIntensity();
                y += (int)((double)this.field_2034.method_43048(intensity) - java.lang.Math.ceil((float)intensity / 2.0f));
            }
            if (config.getOrientation() == ArmorHudConfig.Orientation.HORIZONTAL) {
                if (!config.getAnchor().isTop()) {
                    y -= 10;
                }
                int warnX = 7;
                context.method_25290(class_10799.field_56883, WARNING_TEXTURE, x + warnX, y + 1, 0.0f, 0.0f, 8, 8, 8, 8);
                continue;
            }
            if (extrasSide == class_1306.field_6182) {
                x -= 10;
            }
            int warnY = 7;
            context.method_25290(class_10799.field_56883, WARNING_TEXTURE, x + 1, y + warnY, 0.0f, 0.0f, 8, 8, 8, 8);
        }
    }

    @Inject(method={"renderStatusEffectOverlay"}, at={@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;")})
    public void calculateStatusEffectIconsOffset(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        this.shift = 0;
        ArmorHudConfig config = (ArmorHudConfig)ArmorHudMod.getManager().getConfig();
        if (!config.isEnabled() || !config.isPushStatusEffectIcons() || config.getAnchor() != ArmorHudConfig.Anchor.TOP || config.getSide() != class_1306.field_6183) {
            return;
        }
        class_1657 player = ArmorHudMod.getCameraPlayer();
        if (player == null) {
            return;
        }
        Optional<class_768> rect = ArmorHudMod.getEffectiveWidgetRect(context, player);
        if (rect.isEmpty()) {
            return;
        }
        this.shift = rect.get().method_3322() + rect.get().method_3320();
    }

    @ModifyVariable(method={"renderStatusEffectOverlay"}, at=@At(value="STORE"), ordinal=3)
    public int statusEffectIconsOffset(int y) {
        return y + this.shift;
    }
}

