/*
 * Decompiled with CFR 0.152.
 */
package com.etema.potioneffectsmodify;

import com.etema.potioneffectsmodify.PotionEffectsModify;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;

public class CuriosIntegration {
    private static boolean initialized = false;
    private static boolean curiosLoaded = false;

    public static void initialize() {
        if (initialized) {
            return;
        }
        try {
            if (ModList.get().isLoaded("curios")) {
                Class.forName("top.theillusivec4.curios.api.CuriosApi");
                curiosLoaded = true;
                PotionEffectsModify.LOGGER.info("Curios integration enabled");
            } else {
                PotionEffectsModify.LOGGER.info("Curios not found - integration disabled");
            }
            initialized = true;
        }
        catch (ClassNotFoundException e) {
            PotionEffectsModify.LOGGER.info("Curios classes not found - integration disabled");
        }
        catch (Exception e) {
            PotionEffectsModify.LOGGER.warn("Curios integration failed: {}", (Object)e.getMessage());
        }
    }

    public static boolean isCuriosLoaded() {
        return curiosLoaded;
    }

    public static List<ItemStack> getCuriosItems(Player player) {
        ArrayList<ItemStack> curiosItems = new ArrayList<ItemStack>();
        if (!curiosLoaded) {
            return curiosItems;
        }
        try {
            curiosItems.addAll(CuriosIntegration.getCuriosItemsInternal(player));
        }
        catch (Exception e) {
            PotionEffectsModify.LOGGER.error("Error getting curios items: {}", (Object)e.getMessage());
        }
        return curiosItems;
    }

    public static List<CuriosItemSlot> getCuriosItemsWithSlots(Player player) {
        ArrayList<CuriosItemSlot> curiosItems = new ArrayList<CuriosItemSlot>();
        if (!curiosLoaded) {
            return curiosItems;
        }
        try {
            curiosItems.addAll(CuriosIntegration.getCuriosItemsWithSlotsInternal(player));
        }
        catch (Exception e) {
            PotionEffectsModify.LOGGER.error("Error getting curios items with slots: {}", (Object)e.getMessage());
        }
        return curiosItems;
    }

    private static List<ItemStack> getCuriosItemsInternal(Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        return items;
    }

    private static List<CuriosItemSlot> getCuriosItemsWithSlotsInternal(Player player) {
        ArrayList<CuriosItemSlot> items = new ArrayList<CuriosItemSlot>();
        return items;
    }

    public static boolean isCuriosSlot(String slotName) {
        if (!curiosLoaded) {
            return false;
        }
        return switch (slotName.toLowerCase()) {
            case "ring", "necklace", "bracelet", "charm", "body", "hands", "belt", "back" -> true;
            default -> false;
        };
    }

    public static class CuriosItemSlot {
        public final ItemStack itemStack;
        public final String slotType;
        public final int slotIndex;

        public CuriosItemSlot(ItemStack itemStack, String slotType, int slotIndex) {
            this.itemStack = itemStack;
            this.slotType = slotType;
            this.slotIndex = slotIndex;
        }
    }
}

