/*
 * Decompiled with CFR 0.152.
 */
package com.etema.potioneffectsmodify;

import com.etema.potioneffectsmodify.PotionEffectsModify;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionEffectDataManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static PotionEffectDataManager instance;
    private final Map<Item, List<PotionEffectEntry>> passiveEffects = new HashMap<Item, List<PotionEffectEntry>>();
    private final Map<Item, List<PotionEffectEntry>> onHitEffects = new HashMap<Item, List<PotionEffectEntry>>();
    private final Map<Item, List<PotionEffectEntry>> onHurtEffects = new HashMap<Item, List<PotionEffectEntry>>();

    public PotionEffectDataManager() {
        super(GSON, "potion_effects");
        instance = this;
    }

    public static PotionEffectDataManager getInstance() {
        if (instance == null) {
            instance = new PotionEffectDataManager();
        }
        return instance;
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.passiveEffects.clear();
        this.onHitEffects.clear();
        this.onHurtEffects.clear();
        PotionEffectsModify.LOGGER.info("Loading potion effects from {} datapack files", (Object)data.size());
        data.forEach((resourceLocation, jsonElement) -> {
            try {
                PotionEffectsModify.LOGGER.debug("Processing file: {}", resourceLocation);
                JsonObject root = jsonElement.getAsJsonObject();
                root.entrySet().forEach(entry -> {
                    String itemId = (String)entry.getKey();
                    JsonObject itemData = ((JsonElement)entry.getValue()).getAsJsonObject();
                    ResourceLocation itemLoc = ResourceLocation.parse((String)itemId);
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLoc);
                    if (item == null) {
                        PotionEffectsModify.LOGGER.warn("Unknown item: {} in file: {}", (Object)itemId, resourceLocation);
                        return;
                    }
                    this.processItemEffects(item, itemData);
                    PotionEffectsModify.LOGGER.debug("Processed effects for item: {}", (Object)itemId);
                });
            }
            catch (Exception e) {
                PotionEffectsModify.LOGGER.error("Error processing potion effects data from {}: {}", resourceLocation, (Object)e.getMessage());
            }
        });
        PotionEffectsModify.LOGGER.info("Loaded {} passive, {} onHit, {} onHurt effect entries", new Object[]{this.passiveEffects.size(), this.onHitEffects.size(), this.onHurtEffects.size()});
    }

    private void processItemEffects(Item item, JsonObject itemData) {
        if (itemData.has("passive_effects")) {
            itemData.getAsJsonArray("passive_effects").forEach(effectElement -> {
                PotionEffectEntry entry = this.parseEffectEntry(effectElement.getAsJsonObject(), "passive");
                if (entry != null) {
                    this.passiveEffects.computeIfAbsent(item, k -> new ArrayList()).add(entry);
                }
            });
        }
        if (itemData.has("on_hit_effects")) {
            itemData.getAsJsonArray("on_hit_effects").forEach(effectElement -> {
                PotionEffectEntry entry = this.parseEffectEntry(effectElement.getAsJsonObject(), "onHit");
                if (entry != null) {
                    this.onHitEffects.computeIfAbsent(item, k -> new ArrayList()).add(entry);
                }
            });
        }
        if (itemData.has("on_hurt_effects")) {
            itemData.getAsJsonArray("on_hurt_effects").forEach(effectElement -> {
                PotionEffectEntry entry = this.parseEffectEntry(effectElement.getAsJsonObject(), "onHurt");
                if (entry != null) {
                    this.onHurtEffects.computeIfAbsent(item, k -> new ArrayList()).add(entry);
                }
            });
        }
    }

    private PotionEffectEntry parseEffectEntry(JsonObject effectObj, String triggerType) {
        try {
            String effectId = effectObj.get("effect").getAsString();
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ResourceLocation.parse((String)effectId));
            if (effect == null) {
                PotionEffectsModify.LOGGER.warn("Unknown effect: {}", (Object)effectId);
                return null;
            }
            int amplifier = effectObj.has("amplifier") ? effectObj.get("amplifier").getAsInt() : 0;
            int duration = effectObj.has("duration") ? effectObj.get("duration").getAsInt() : 200;
            float chance = effectObj.has("chance") ? effectObj.get("chance").getAsFloat() : 1.0f;
            boolean permanent = effectObj.has("permanent") && effectObj.get("permanent").getAsBoolean();
            String slot = effectObj.has("slot") ? effectObj.get("slot").getAsString() : "any";
            boolean isCurio = effectObj.has("is_curio") && effectObj.get("is_curio").getAsBoolean();
            return new PotionEffectEntry(effect, amplifier, duration, chance, permanent, triggerType, slot, isCurio);
        }
        catch (Exception e) {
            PotionEffectsModify.LOGGER.error("Error parsing effect entry: {}", (Object)e.getMessage());
            return null;
        }
    }

    public List<PotionEffectEntry> getPassiveEffects(Item item) {
        return this.passiveEffects.getOrDefault(item, Collections.emptyList());
    }

    public List<PotionEffectEntry> getOnHitEffects(Item item) {
        return this.onHitEffects.getOrDefault(item, Collections.emptyList());
    }

    public List<PotionEffectEntry> getOnHurtEffects(Item item) {
        return this.onHurtEffects.getOrDefault(item, Collections.emptyList());
    }

    public List<PotionEffectEntry> getAllEffects(Item item) {
        ArrayList<PotionEffectEntry> allEffects = new ArrayList<PotionEffectEntry>();
        allEffects.addAll(this.getPassiveEffects(item));
        allEffects.addAll(this.getOnHitEffects(item));
        allEffects.addAll(this.getOnHurtEffects(item));
        return allEffects;
    }

    public static class PotionEffectEntry {
        public final MobEffect effect;
        public final int amplifier;
        public final int duration;
        public final float chance;
        public final boolean permanent;
        public final String triggerType;
        public final String slot;
        public final boolean isCurio;

        public PotionEffectEntry(MobEffect effect, int amplifier, int duration, float chance, boolean permanent, String triggerType, String slot, boolean isCurio) {
            this.effect = effect;
            this.amplifier = amplifier;
            this.duration = duration;
            this.chance = chance;
            this.permanent = permanent;
            this.triggerType = triggerType;
            this.slot = slot;
            this.isCurio = isCurio;
        }
    }
}

