/*
 * Decompiled with CFR 0.152.
 */
package com.etema.potioneffectsmodify;

import com.etema.potioneffectsmodify.CuriosIntegration;
import com.etema.potioneffectsmodify.PotionEffectDataManager;
import com.etema.potioneffectsmodify.PotionEffectsModify;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="potioneffectsmodify", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PotionEffectHandler {
    private static final Random RANDOM = new Random();
    private static final Map<UUID, Map<String, Set<ActiveEffect>>> playerActiveEffects = new ConcurrentHashMap<UUID, Map<String, Set<ActiveEffect>>>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().m_5776_()) {
            return;
        }
        Player player = event.player;
        if (player.f_19797_ % 20 == 0) {
            PotionEffectHandler.processPassiveEffectsBySlot(player);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        LivingEntity victim = event.getEntity();
        LivingEntity attacker = null;
        if (event.getSource().m_7639_() instanceof LivingEntity) {
            attacker = (LivingEntity)event.getSource().m_7639_();
        }
        if (victim instanceof Player) {
            PotionEffectHandler.processOnHurtEffectsBySlot((Player)victim);
        }
        if (attacker instanceof Player) {
            PotionEffectHandler.processOnHitEffectsBySlot((Player)attacker, victim);
        }
    }

    private static void processPassiveEffectsBySlot(Player player) {
        try {
            UUID playerId = player.m_20148_();
            HashMap<String, Set<ActiveEffect>> currentEffects = new HashMap<String, Set<ActiveEffect>>();
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack itemStack = player.m_6844_(slot);
                String slotName = PotionEffectHandler.getSlotName(slot);
                if (itemStack.m_41619_()) continue;
                PotionEffectHandler.processSlotEffects(player, itemStack, slotName, currentEffects);
            }
            PotionEffectHandler.processCuriosPassiveEffects(player, currentEffects);
            PotionEffectHandler.cleanupInactiveEffects(player, currentEffects);
            playerActiveEffects.put(playerId, currentEffects);
        }
        catch (Exception e) {
            PotionEffectsModify.LOGGER.error("Error in processPassiveEffectsBySlot: {}", (Object)e.getMessage());
        }
    }

    private static void processSlotEffects(Player player, ItemStack itemStack, String slotName, Map<String, Set<ActiveEffect>> currentEffects) {
        List<PotionEffectDataManager.PotionEffectEntry> effects = PotionEffectDataManager.getInstance().getPassiveEffects(itemStack.m_41720_());
        for (PotionEffectDataManager.PotionEffectEntry effectEntry : effects) {
            if (!PotionEffectHandler.shouldApplyEffectForSlot(effectEntry, slotName)) continue;
            ActiveEffect activeEffect = new ActiveEffect(effectEntry.effect, effectEntry.amplifier, slotName, itemStack.m_41720_());
            currentEffects.computeIfAbsent(slotName, k -> new HashSet()).add(activeEffect);
            if (effectEntry.permanent) {
                PotionEffectHandler.applyPermanentEffect((LivingEntity)player, effectEntry);
                continue;
            }
            PotionEffectHandler.applyTemporaryEffect((LivingEntity)player, effectEntry);
        }
    }

    private static void processCuriosPassiveEffects(Player player, Map<String, Set<ActiveEffect>> currentEffects) {
        if (!CuriosIntegration.isCuriosLoaded()) {
            return;
        }
        try {
            List<CuriosIntegration.CuriosItemSlot> curiosItems = CuriosIntegration.getCuriosItemsWithSlots(player);
            for (CuriosIntegration.CuriosItemSlot curiosItem : curiosItems) {
                List<PotionEffectDataManager.PotionEffectEntry> effects = PotionEffectDataManager.getInstance().getPassiveEffects(curiosItem.itemStack.m_41720_());
                for (PotionEffectDataManager.PotionEffectEntry effectEntry : effects) {
                    if (!effectEntry.isCurio && !PotionEffectHandler.shouldApplyEffectForSlot(effectEntry, curiosItem.slotType)) continue;
                    ActiveEffect activeEffect = new ActiveEffect(effectEntry.effect, effectEntry.amplifier, curiosItem.slotType, curiosItem.itemStack.m_41720_());
                    currentEffects.computeIfAbsent(curiosItem.slotType, k -> new HashSet()).add(activeEffect);
                    if (effectEntry.permanent) {
                        PotionEffectHandler.applyPermanentEffect((LivingEntity)player, effectEntry);
                        continue;
                    }
                    PotionEffectHandler.applyTemporaryEffect((LivingEntity)player, effectEntry);
                }
            }
        }
        catch (Exception e) {
            PotionEffectsModify.LOGGER.error("Error in processCuriosPassiveEffects: {}", (Object)e.getMessage());
        }
    }

    private static void cleanupInactiveEffects(Player player, Map<String, Set<ActiveEffect>> currentEffects) {
        UUID playerId = player.m_20148_();
        Map<String, Set<ActiveEffect>> previousEffects = playerActiveEffects.get(playerId);
        if (previousEffects == null) {
            return;
        }
        for (Map.Entry<String, Set<ActiveEffect>> entry : previousEffects.entrySet()) {
            String slot = entry.getKey();
            Set<ActiveEffect> oldEffects = entry.getValue();
            Set newEffects = currentEffects.getOrDefault(slot, Collections.emptySet());
            for (ActiveEffect oldEffect : oldEffects) {
                if (newEffects.contains(oldEffect)) continue;
                PotionEffectHandler.removeEffect(player, oldEffect);
            }
        }
    }

    private static void removeEffect(Player player, ActiveEffect activeEffect) {
        try {
            MobEffectInstance currentEffect = player.m_21124_(activeEffect.effect);
            if (currentEffect != null && currentEffect.m_19564_() == activeEffect.amplifier) {
                player.m_21195_(activeEffect.effect);
                PotionEffectsModify.LOGGER.debug("Removed effect {} from {} slot", (Object)activeEffect.effect.m_19482_().getString(), (Object)activeEffect.sourceSlot);
            }
        }
        catch (Exception e) {
            PotionEffectsModify.LOGGER.error("Error removing effect: {}", (Object)e.getMessage());
        }
    }

    private static void processOnHitEffectsBySlot(Player attacker, LivingEntity victim) {
        try {
            ItemStack offHandItem;
            ItemStack mainHandItem = attacker.m_21205_();
            if (!mainHandItem.m_41619_()) {
                PotionEffectHandler.processOnHitForSpecificSlot(attacker, victim, mainHandItem, "mainhand");
            }
            if (!(offHandItem = attacker.m_21206_()).m_41619_()) {
                PotionEffectHandler.processOnHitForSpecificSlot(attacker, victim, offHandItem, "offhand");
            }
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack armorItem;
                if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND || (armorItem = attacker.m_6844_(slot)).m_41619_()) continue;
                PotionEffectHandler.processOnHitForSpecificSlot(attacker, victim, armorItem, PotionEffectHandler.getSlotName(slot));
            }
        }
        catch (Exception e) {
            PotionEffectsModify.LOGGER.error("Error in processOnHitEffectsBySlot: {}", (Object)e.getMessage());
        }
    }

    private static void processOnHitForSpecificSlot(Player attacker, LivingEntity victim, ItemStack itemStack, String slotName) {
        List<PotionEffectDataManager.PotionEffectEntry> effects = PotionEffectDataManager.getInstance().getOnHitEffects(itemStack.m_41720_());
        for (PotionEffectDataManager.PotionEffectEntry effectEntry : effects) {
            if (!PotionEffectHandler.shouldApplyEffectForSlot(effectEntry, slotName) || !(RANDOM.nextFloat() <= effectEntry.chance)) continue;
            PotionEffectHandler.applyTemporaryEffect(victim, effectEntry);
        }
    }

    private static void processOnHurtEffectsBySlot(Player victim) {
        try {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack itemStack = victim.m_6844_(slot);
                if (itemStack.m_41619_()) continue;
                String slotName = PotionEffectHandler.getSlotName(slot);
                List<PotionEffectDataManager.PotionEffectEntry> effects = PotionEffectDataManager.getInstance().getOnHurtEffects(itemStack.m_41720_());
                for (PotionEffectDataManager.PotionEffectEntry effectEntry : effects) {
                    if (!PotionEffectHandler.shouldApplyEffectForSlot(effectEntry, slotName) || !(RANDOM.nextFloat() <= effectEntry.chance)) continue;
                    PotionEffectHandler.applyTemporaryEffect((LivingEntity)victim, effectEntry);
                }
            }
        }
        catch (Exception e) {
            PotionEffectsModify.LOGGER.error("Error in processOnHurtEffectsBySlot: {}", (Object)e.getMessage());
        }
    }

    private static String getSlotName(EquipmentSlot slot) {
        return switch (slot) {
            default -> throw new IncompatibleClassChangeError();
            case EquipmentSlot.MAINHAND -> "mainhand";
            case EquipmentSlot.OFFHAND -> "offhand";
            case EquipmentSlot.FEET -> "feet";
            case EquipmentSlot.LEGS -> "legs";
            case EquipmentSlot.CHEST -> "chest";
            case EquipmentSlot.HEAD -> "head";
        };
    }

    private static boolean shouldApplyEffectForSlot(PotionEffectDataManager.PotionEffectEntry effectEntry, String currentSlot) {
        if ("any".equalsIgnoreCase(effectEntry.slot)) {
            return true;
        }
        if (currentSlot.equalsIgnoreCase(effectEntry.slot)) {
            return true;
        }
        return switch (effectEntry.slot.toLowerCase()) {
            case "helmet" -> "head".equals(currentSlot);
            case "chestplate" -> "chest".equals(currentSlot);
            case "leggings" -> "legs".equals(currentSlot);
            case "boots" -> "feet".equals(currentSlot);
            case "weapon" -> {
                if ("mainhand".equals(currentSlot) || "offhand".equals(currentSlot)) {
                    yield true;
                }
                yield false;
            }
            case "armor" -> {
                if ("head".equals(currentSlot) || "chest".equals(currentSlot) || "legs".equals(currentSlot) || "feet".equals(currentSlot)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static void applyPermanentEffect(LivingEntity entity, PotionEffectDataManager.PotionEffectEntry effectEntry) {
        try {
            MobEffectInstance currentEffect = entity.m_21124_(effectEntry.effect);
            if (currentEffect == null || currentEffect.m_19564_() != effectEntry.amplifier) {
                MobEffectInstance effectInstance = new MobEffectInstance(effectEntry.effect, 40, effectEntry.amplifier, false, false, true);
                entity.m_7292_(effectInstance);
            }
        }
        catch (Exception e) {
            PotionEffectsModify.LOGGER.error("Error applying permanent effect: {}", (Object)e.getMessage());
        }
    }

    private static void applyTemporaryEffect(LivingEntity entity, PotionEffectDataManager.PotionEffectEntry effectEntry) {
        try {
            MobEffectInstance effectInstance = new MobEffectInstance(effectEntry.effect, effectEntry.duration, effectEntry.amplifier, false, true, true);
            entity.m_7292_(effectInstance);
        }
        catch (Exception e) {
            PotionEffectsModify.LOGGER.error("Error applying temporary effect: {}", (Object)e.getMessage());
        }
    }

    public static void cleanupPlayer(UUID playerId) {
        playerActiveEffects.remove(playerId);
    }

    public static Map<String, Set<ActiveEffect>> getPlayerActiveEffects(Player player) {
        return playerActiveEffects.getOrDefault(player.m_20148_(), Collections.emptyMap());
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PotionEffectHandler.cleanupPlayer(serverPlayer.m_20148_());
            PotionEffectsModify.LOGGER.debug("Cleaned up data for player: {}", (Object)serverPlayer.m_7755_().getString());
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PotionEffectHandler.cleanupPlayer(serverPlayer.m_20148_());
            PotionEffectsModify.LOGGER.debug("Reset effects for respawned player: {}", (Object)serverPlayer.m_7755_().getString());
        }
    }

    public static class ActiveEffect {
        public final MobEffect effect;
        public final int amplifier;
        public final String sourceSlot;
        public final Item sourceItem;

        public ActiveEffect(MobEffect effect, int amplifier, String sourceSlot, Item sourceItem) {
            this.effect = effect;
            this.amplifier = amplifier;
            this.sourceSlot = sourceSlot;
            this.sourceItem = sourceItem;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ActiveEffect)) {
                return false;
            }
            ActiveEffect other = (ActiveEffect)obj;
            return this.effect.equals(other.effect) && this.amplifier == other.amplifier && this.sourceSlot.equals(other.sourceSlot) && this.sourceItem.equals(other.sourceItem);
        }

        public int hashCode() {
            return Objects.hash(this.effect, this.amplifier, this.sourceSlot, this.sourceItem);
        }
    }
}

