/*
 * Decompiled with CFR 0.152.
 */
package com.etema.potioneffectsmodify;

import com.etema.potioneffectsmodify.CuriosIntegration;
import com.etema.potioneffectsmodify.NetworkHandler;
import com.etema.potioneffectsmodify.PotionEffectDataManager;
import com.etema.potioneffectsmodify.PotionEffectHandler;
import com.etema.potioneffectsmodify.TooltipHandler;
import com.mojang.logging.LogUtils;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="potioneffectsmodify")
public class PotionEffectsModify {
    public static final String MODID = "potioneffectsmodify";
    public static final Logger LOGGER = LogUtils.getLogger();

    public PotionEffectsModify(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        LOGGER.info("PotionEffectsModify initializing...");
        try {
            MinecraftForge.EVENT_BUS.register(PotionEffectHandler.class);
            MinecraftForge.EVENT_BUS.register(TooltipHandler.class);
            MinecraftForge.EVENT_BUS.register((Object)this);
            LOGGER.info("Event handlers registered successfully");
        }
        catch (Exception e) {
            LOGGER.warn("Failed to register handlers: {}", (Object)e.getMessage());
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            try {
                NetworkHandler.initialize();
                CuriosIntegration.initialize();
                LOGGER.info("PotionEffectsModify setup completed successfully");
            }
            catch (Exception e) {
                LOGGER.error("Error during setup: {}", (Object)e.getMessage());
            }
        });
    }

    @SubscribeEvent
    public void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new PotionEffectDataManager());
        LOGGER.info("PotionEffectDataManager registered as reload listener");
    }
}

