/*
 * Decompiled with CFR 0.152.
 */
package com.etema.potioneffectsmodify;

import com.etema.potioneffectsmodify.PotionEffectDataManager;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="potioneffectsmodify", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TooltipHandler {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (itemStack.m_41619_()) {
            return;
        }
        try {
            List<PotionEffectDataManager.PotionEffectEntry> allEffects = PotionEffectDataManager.getInstance().getAllEffects(itemStack.m_41720_());
            if (!allEffects.isEmpty()) {
                event.getToolTip().add(Component.m_237113_((String)""));
                event.getToolTip().add(Component.m_237113_((String)"Potion Effects:").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
                for (PotionEffectDataManager.PotionEffectEntry effectEntry : allEffects) {
                    TooltipHandler.addEffectTooltipWithSlot(event.getToolTip(), effectEntry);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addEffectTooltipWithSlot(List<Component> tooltip, PotionEffectDataManager.PotionEffectEntry effectEntry) {
        String effectName = effectEntry.effect.m_19482_().getString();
        String level = TooltipHandler.getRomanNumeral(effectEntry.amplifier + 1);
        String duration = effectEntry.permanent ? "Permanent" : TooltipHandler.formatDuration(effectEntry.duration);
        ChatFormatting color = TooltipHandler.getEffectColor(effectEntry.triggerType);
        ChatFormatting levelColor = effectEntry.effect.m_19486_() ? ChatFormatting.GREEN : ChatFormatting.RED;
        MutableComponent effectLine = Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)"\u2022 ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)(effectName + " " + level)).m_130940_(levelColor)).m_7220_((Component)Component.m_237113_((String)(" (" + duration + ")")).m_130940_(ChatFormatting.GRAY));
        String slotInfo = TooltipHandler.getSlotDisplayName(effectEntry.slot);
        String triggerText = switch (effectEntry.triggerType) {
            case "passive" -> "Passive";
            case "onHit" -> {
                if (effectEntry.chance < 1.0f) {
                    yield String.format("On Hit (%.0f%%)", Float.valueOf(effectEntry.chance * 100.0f));
                }
                yield "On Hit";
            }
            case "onHurt" -> {
                if (effectEntry.chance < 1.0f) {
                    yield String.format("On Hurt (%.0f%%)", Float.valueOf(effectEntry.chance * 100.0f));
                }
                yield "On Hurt";
            }
            default -> "Unknown";
        };
        effectLine = effectLine.m_7220_((Component)Component.m_237113_((String)(" - " + triggerText)).m_130940_(color)).m_7220_((Component)Component.m_237113_((String)(" [" + slotInfo + "]")).m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)effectLine);
    }

    private static String getSlotDisplayName(String slot) {
        return switch (slot.toLowerCase()) {
            case "mainhand" -> "Main Hand";
            case "offhand" -> "Off Hand";
            case "head", "helmet" -> "Head";
            case "chest", "chestplate" -> "Chest";
            case "legs", "leggings" -> "Legs";
            case "feet", "boots" -> "Feet";
            case "weapon" -> "Weapon";
            case "armor" -> "Any Armor";
            case "any" -> "Any Slot";
            case "ring", "necklace", "bracelet", "charm", "body", "hands", "belt", "back" -> "Curio";
            default -> slot;
        };
    }

    private static ChatFormatting getEffectColor(String triggerType) {
        return switch (triggerType) {
            case "passive" -> ChatFormatting.BLUE;
            case "onHit" -> ChatFormatting.DARK_RED;
            case "onHurt" -> ChatFormatting.YELLOW;
            default -> ChatFormatting.GRAY;
        };
    }

    private static String getRomanNumeral(int number) {
        return switch (number) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            case 5 -> "V";
            default -> String.valueOf(number);
        };
    }

    private static String formatDuration(int ticks) {
        int seconds = ticks / 20;
        if (seconds < 60) {
            return seconds + "s";
        }
        int minutes = seconds / 60;
        int remainingSeconds = seconds % 60;
        return minutes + "m " + remainingSeconds + "s";
    }
}

