/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.stellartms;

import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.pokemon.Species;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.util.ArrayList;
import java.util.List;
import kotlin.random.Random;
import me.lucko.fabric.api.permissions.v0.Permissions;
import me.unariginal.stellartms.config.Config;
import me.unariginal.stellartms.data.DataComponents;
import me.unariginal.stellartms.handler.ItemHandler;
import me.unariginal.stellartms.utils.TextUtils;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.kyori.adventure.platform.fabric.FabricServerAudiences;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_3222;
import net.minecraft.class_9323;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StellarTMs
implements ModInitializer {
    public static final String MOD_ID = "stellartms";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"stellartms");
    public static StellarTMs INSTANCE;
    public static boolean DEBUG;
    public MinecraftServer server;
    public FabricServerAudiences audiences;
    public Config config;

    public void onInitialize() {
        INSTANCE = this;
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)MOD_ID).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"give").requires(Permissions.require((String)"stellartms.give", (int)4))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"tm").then(class_2170.method_9244((String)"move", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            builder.suggest("blank");
            Moves.INSTANCE.all().forEach(move -> builder.suggest(move.getName().toLowerCase()));
            return builder.buildFuture();
        }).executes(ctx -> {
            String move = StringArgumentType.getString((CommandContext)ctx, (String)"move");
            MoveTemplate moveTemplate = Moves.INSTANCE.getByName(move);
            if (moveTemplate == null) {
                move = "blank";
            }
            List<class_3222> players = class_2186.method_9312((CommandContext)ctx, (String)"player").stream().toList();
            this.giveTM((CommandContext<class_2168>)ctx, moveTemplate, move, players);
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"random").executes(ctx -> {
            List<MoveTemplate> validMoveTemplates = this.getValidMoves("");
            MoveTemplate moveTemplate = validMoveTemplates.get(Random.Default.nextInt(validMoveTemplates.size()));
            String move = moveTemplate.getName();
            List<class_3222> players = class_2186.method_9312((CommandContext)ctx, (String)"player").stream().toList();
            this.giveTM((CommandContext<class_2168>)ctx, moveTemplate, move, players);
            return 1;
        })).then(class_2170.method_9244((String)"filter", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String filterArg = StringArgumentType.getString((CommandContext)ctx, (String)"filter");
            List<MoveTemplate> validMoveTemplates = this.getValidMoves(filterArg);
            MoveTemplate randomSelection = validMoveTemplates.get(Random.Default.nextInt(validMoveTemplates.size()));
            List<class_3222> players = class_2186.method_9312((CommandContext)ctx, (String)"player").stream().toList();
            this.giveTM((CommandContext<class_2168>)ctx, randomSelection, randomSelection.getName(), players);
            return 1;
        })))))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"tr").then(class_2170.method_9244((String)"move", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            builder.suggest("blank");
            Moves.INSTANCE.all().forEach(move -> builder.suggest(move.getName()));
            return builder.buildFuture();
        }).executes(ctx -> {
            String move = StringArgumentType.getString((CommandContext)ctx, (String)"move");
            MoveTemplate moveTemplate = Moves.INSTANCE.getByName(move);
            if (moveTemplate == null) {
                move = "blank";
            }
            List<class_3222> players = class_2186.method_9312((CommandContext)ctx, (String)"player").stream().toList();
            this.giveTR((CommandContext<class_2168>)ctx, moveTemplate, move, players);
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"random").executes(ctx -> {
            List<MoveTemplate> validMoveTemplates = this.getValidMoves("");
            MoveTemplate moveTemplate = validMoveTemplates.get(Random.Default.nextInt(validMoveTemplates.size()));
            String move = moveTemplate.getName();
            List<class_3222> players = class_2186.method_9312((CommandContext)ctx, (String)"player").stream().toList();
            this.giveTR((CommandContext<class_2168>)ctx, moveTemplate, move, players);
            return 1;
        })).then(class_2170.method_9244((String)"filter", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String filterArg = StringArgumentType.getString((CommandContext)ctx, (String)"filter");
            List<MoveTemplate> validMoveTemplates = this.getValidMoves(filterArg);
            MoveTemplate randomSelection = validMoveTemplates.get(Random.Default.nextInt(validMoveTemplates.size()));
            List<class_3222> players = class_2186.method_9312((CommandContext)ctx, (String)"player").stream().toList();
            this.giveTR((CommandContext<class_2168>)ctx, randomSelection, randomSelection.getName(), players);
            return 1;
        }))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(Permissions.require((String)"stellartms.reload", (int)4))).executes(ctx -> {
            this.reload();
            ((class_2168)ctx.getSource()).method_45068(TextUtils.deserialize(TextUtils.parse(this.config.reload_message)));
            return 1;
        }))));
        this.reload();
        PolymerResourcePackUtils.markAsRequired();
        PolymerResourcePackUtils.addModAssets((String)MOD_ID);
        ItemHandler.registerItems();
        ItemHandler.registerItemGroup();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.server = server;
            this.audiences = FabricServerAudiences.of((MinecraftServer)server);
        });
    }

    public void reload() {
        this.config = new Config();
    }

    public void giveTM(CommandContext<class_2168> ctx, MoveTemplate moveTemplate, String move, List<class_3222> players) {
        class_1799 toGive = ItemHandler.StellarTM.method_7854();
        toGive.method_57365(class_9323.method_57827().method_57840(DataComponents.MOVE, (Object)move).method_57838());
        for (class_3222 player : players) {
            player.method_7270(toGive);
            ((class_2168)ctx.getSource()).method_45068(TextUtils.deserialize(TextUtils.parse(TextUtils.parse(this.config.tm_give_message, player), moveTemplate)));
        }
    }

    public void giveTR(CommandContext<class_2168> ctx, MoveTemplate moveTemplate, String move, List<class_3222> players) {
        class_1799 toGive = ItemHandler.StellarTR.method_7854();
        toGive.method_57365(class_9323.method_57827().method_57840(DataComponents.MOVE, (Object)move).method_57838());
        for (class_3222 player : players) {
            player.method_7270(toGive);
            ((class_2168)ctx.getSource()).method_45068(TextUtils.deserialize(TextUtils.parse(TextUtils.parse(this.config.tr_give_message, player), moveTemplate)));
        }
    }

    public List<MoveTemplate> getValidMoves(String filterArg) {
        String[] filters = filterArg.split(";");
        ArrayList<MoveTemplate> validMoveTemplates = new ArrayList<MoveTemplate>(Moves.INSTANCE.all());
        boolean containsZFilter = false;
        boolean containsMaxFilter = false;
        boolean containsGmaxFilter = false;
        for (String filter : filters) {
            String[] filterDetails = filter.split(":");
            if (filter.length() < 2) continue;
            String filterType = filterDetails[0];
            String filterOption = filterDetails[1];
            boolean antiFilter = filterType.startsWith("!");
            if (antiFilter) {
                filterType = filterType.substring(1);
            }
            String finalFilterOption = filterOption;
            switch (filterType) {
                case "type": {
                    String[] types = finalFilterOption.split(",");
                    ArrayList<String> validTypes = new ArrayList<String>();
                    for (String string : types) {
                        if (!ElementalTypes.INSTANCE.all().stream().anyMatch(elementalType -> elementalType.getName().equalsIgnoreCase(string))) continue;
                        validTypes.add(string);
                    }
                    validMoveTemplates.removeIf(template -> {
                        if (antiFilter) {
                            for (String type : validTypes) {
                                boolean typeMatches = template.getElementalType().getName().equalsIgnoreCase(type);
                                if (!typeMatches) continue;
                                return true;
                            }
                            return false;
                        }
                        for (String type : validTypes) {
                            if (!template.getElementalType().getName().equalsIgnoreCase(type)) continue;
                            return false;
                        }
                        return true;
                    });
                    break;
                }
                case "category": {
                    if (!finalFilterOption.equalsIgnoreCase("status") && !finalFilterOption.equalsIgnoreCase("physical") && !finalFilterOption.equalsIgnoreCase("special")) break;
                    validMoveTemplates.removeIf(template -> {
                        boolean categoryMatches = template.getDamageCategory().getName().equalsIgnoreCase(finalFilterOption);
                        if (antiFilter) {
                            return categoryMatches;
                        }
                        return !categoryMatches;
                    });
                    break;
                }
                case "gimmick": {
                    if (finalFilterOption.equalsIgnoreCase("z") || finalFilterOption.equalsIgnoreCase("zmove") || finalFilterOption.equalsIgnoreCase("zpower")) {
                        containsZFilter = true;
                        validMoveTemplates.removeIf(template -> {
                            boolean isZMove = this.config.zMoves.contains(template.getName().toLowerCase());
                            if (antiFilter) {
                                return isZMove;
                            }
                            return !isZMove;
                        });
                    }
                    if (finalFilterOption.equalsIgnoreCase("max") || finalFilterOption.equalsIgnoreCase("dynamax")) {
                        containsMaxFilter = true;
                        validMoveTemplates.removeIf(template -> {
                            boolean isMaxMove = this.config.maxMoves.contains(template.getName().toLowerCase());
                            if (antiFilter) {
                                return isMaxMove;
                            }
                            return !isMaxMove;
                        });
                    }
                    if (!finalFilterOption.equalsIgnoreCase("gmax") && !finalFilterOption.equalsIgnoreCase("gigantamax")) break;
                    containsGmaxFilter = true;
                    validMoveTemplates.removeIf(template -> {
                        boolean isGMaxMove = this.config.gmaxMoves.contains(template.getName().toLowerCase());
                        if (antiFilter) {
                            return isGMaxMove;
                        }
                        return !isGMaxMove;
                    });
                    break;
                }
                case "learnedby": 
                case "learnset": {
                    String[] split = finalFilterOption.split("#");
                    boolean containsTM = false;
                    boolean containsEgg = false;
                    boolean containsTutor = false;
                    boolean containsLevel = false;
                    for (String option : split) {
                        if (option.equalsIgnoreCase("tm")) {
                            containsTM = true;
                        }
                        if (option.equalsIgnoreCase("egg")) {
                            containsEgg = true;
                        }
                        if (option.equalsIgnoreCase("tutor")) {
                            containsTutor = true;
                        }
                        if (!option.equalsIgnoreCase("level") && !option.equalsIgnoreCase("levelup")) continue;
                        containsLevel = true;
                    }
                    Species species = PokemonSpecies.INSTANCE.getByName(split[0]);
                    if (species == null) break;
                    ArrayList validLearnsets = new ArrayList();
                    if (!(containsTutor || containsTM || containsEgg || containsLevel)) {
                        validLearnsets.addAll(species.getMoves().getTmMoves());
                        validLearnsets.addAll(species.getMoves().getEggMoves());
                        validLearnsets.addAll(species.getMoves().getTutorMoves());
                        for (List levelUpMoves : species.getMoves().getLevelUpMoves().values()) {
                            validLearnsets.addAll(levelUpMoves);
                        }
                    }
                    if (containsLevel) {
                        for (List levelUpMoves : species.getMoves().getLevelUpMoves().values()) {
                            validLearnsets.addAll(levelUpMoves);
                        }
                    }
                    if (containsTM) {
                        validLearnsets.addAll(species.getMoves().getTmMoves());
                    }
                    if (containsEgg) {
                        validLearnsets.addAll(species.getMoves().getEggMoves());
                    }
                    if (containsTutor) {
                        validLearnsets.addAll(species.getMoves().getTutorMoves());
                    }
                    validMoveTemplates.removeIf(moveTemplate -> !validLearnsets.contains(moveTemplate));
                }
            }
            boolean finalContainsZFilter = containsZFilter;
            boolean finalContainsMaxFilter = containsMaxFilter;
            boolean finalContainsGmaxFilter = containsGmaxFilter;
            validMoveTemplates.removeIf(template -> {
                boolean isZMove = this.config.zMoves.contains(template.getName().toLowerCase());
                boolean isMaxMove = this.config.maxMoves.contains(template.getName().toLowerCase());
                boolean isGMaxMove = this.config.gmaxMoves.contains(template.getName().toLowerCase());
                if (!finalContainsZFilter && this.config.autoExcludeZMoves && isZMove) {
                    return true;
                }
                if (!finalContainsMaxFilter && this.config.autoExcludeMaxMoves && isMaxMove) {
                    return true;
                }
                return !finalContainsGmaxFilter && this.config.autoExcludeGMaxMoves && isGMaxMove;
            });
        }
        return validMoveTemplates;
    }

    static {
        DEBUG = false;
    }
}

