/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.stellartms.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import me.unariginal.stellartms.StellarTMs;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public boolean ignore_learnset = false;
    public String tm_base_item = "minecraft:brick";
    public String tm_item_name = "%move_color%TM: %move%";
    public List<String> tm_item_lore = new ArrayList<String>();
    public String blank_tm_item_name = "<gray>Blank TM";
    public List<String> blank_tm_item_lore = new ArrayList<String>();
    public String tr_base_item = "minecraft:nether_brick";
    public String tr_item_name = "%move_color%TR: %move%";
    public List<String> tr_item_lore = new ArrayList<String>();
    public String blank_tr_item_name = "<gray>Blank TR";
    public List<String> blank_tr_item_lore = new ArrayList<String>();
    public String gui_title = "<gold>Pick A Move!";
    public String move_learned_overlay = "<green>%pokemon% has learned %move_color%%move%<green>!";
    public String unable_to_learn_overlay = "<red>%pokemon% cannot learn %move_color%%move%<red>!";
    public String already_learned_overlay = "<gray>%pokemon% already knows %move_color%%move%<gray>!";
    public String prefix = "<dark_gray>[<light_purple>StellarTMs<dark_gray>]";
    public String reload_message = "%prefix% <green>Reloaded!";
    public String tm_give_message = "%prefix% <green>Gave %move_color%TM: %move% <green>to %player%!";
    public String tr_give_message = "%prefix% <green>Gave %move_color%TR: %move% <green>to %player%!";
    public boolean autoExcludeZMoves = true;
    public boolean autoExcludeMaxMoves = true;
    public boolean autoExcludeGMaxMoves = true;
    public List<String> zMoves = new ArrayList<String>(List.of("10000000voltthunderbolt", "aciddownpour", "alloutpummeling", "blackholeeclipse", "bloomdoom", "breakneckblitz", "catastropika", "clangoroussoulblaze", "continentalcrush", "corkscrewcrash", "devastatingdrake", "extremeevoboost", "genesissupernova", "gigavolthavoc", "guardianofalola", "hydrovortex", "infernooverdrive", "letssnuggleforever", "lightthatburnsthesky", "maliciousmoonsault", "menacingmoonrazemaelstrom", "neverendingnightmare", "oceanicoperetta", "pulverizingpancake", "savagespinout", "searingsunrazesmash", "shatteredpsyche", "sinisterarrowraid", "soulstealing7starstrike", "splinteredstormshards", "stokedsparksurfer", "subzeroslammer", "supersonicskystrike", "tectonicrage", "twinkletackle"));
    public List<String> maxMoves = new ArrayList<String>(List.of("maxairstream", "maxdarkness", "maxflare", "maxflutterby", "maxgeyser", "maxguard", "maxhailstorm", "maxknuckle", "maxlightning", "maxmindstorm", "maxooze", "maxovergrowth", "maxphantasm", "maxquake", "maxrockfall", "maxspirit", "maxstarfall", "maxsteelspike", "maxstrike", "maxwyrmwind"));
    public List<String> gmaxMoves = new ArrayList<String>(List.of("gmaxbefuddle", "gmaxcannonade", "gmaxcentiferno", "gmaxchistrike", "gmaxcuddle", "gmaxdepletion", "gmaxdrumsolo", "gmaxfinale", "gmaxfireball", "gmaxfoamburst", "gmaxgoldrush", "gmaxgravitas", "gmaxhydrosnipe", "gmaxmalodor", "gmaxmeltdown", "gmaxoneblow", "gmaxrapidflow", "gmaxreplenish", "gmaxresonance", "gmaxsandblast", "gmaxsmite", "gmaxsnooze", "gmaxsteelsurge", "gmaxstonesurge", "gmaxstunshock", "gmaxsweetness", "gmaxtartness", "gmaxterror", "gmaxvinelash", "gmaxvolcalith", "gmaxvoltcrash", "gmaxwildfire", "gmaxwindrage"));

    public Config() {
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            StellarTMs.LOGGER.error("Could not load config file!", (Throwable)e);
        }
    }

    public void loadConfig() throws IOException {
        JsonArray lore;
        File rootFolder = FabricLoader.getInstance().getConfigDir().resolve("StellarTMs").toFile();
        if (!rootFolder.exists()) {
            rootFolder.mkdirs();
        }
        File configFile = FabricLoader.getInstance().getConfigDir().resolve("StellarTMs/config.json").toFile();
        JsonObject newRoot = new JsonObject();
        JsonObject root = new JsonObject();
        if (configFile.exists()) {
            root = JsonParser.parseReader((Reader)new FileReader(configFile)).getAsJsonObject();
        }
        if (root.has("debug")) {
            StellarTMs.DEBUG = root.get("debug").getAsBoolean();
        }
        newRoot.addProperty("debug", Boolean.valueOf(StellarTMs.DEBUG));
        if (root.has("ignore_learnset")) {
            this.ignore_learnset = root.get("ignore_learnset").getAsBoolean();
        }
        newRoot.addProperty("ignore_learnset", Boolean.valueOf(this.ignore_learnset));
        if (root.has("tm_base_item")) {
            this.tm_base_item = root.get("tm_base_item").getAsString();
        }
        newRoot.addProperty("tm_base_item", this.tm_base_item);
        if (root.has("tm_item_name")) {
            this.tm_item_name = root.get("tm_item_name").getAsString();
        }
        newRoot.addProperty("tm_item_name", this.tm_item_name);
        if (root.has("tm_item_lore")) {
            this.tm_item_lore.clear();
            lore = root.get("tm_item_lore").getAsJsonArray();
            for (JsonElement element : lore) {
                this.tm_item_lore.add(element.getAsString());
            }
        }
        lore = new JsonArray();
        for (String line : this.tm_item_lore) {
            lore.add(line);
        }
        newRoot.add("tm_item_lore", (JsonElement)lore);
        if (root.has("blank_tm_item_name")) {
            this.blank_tm_item_name = root.get("blank_tm_item_name").getAsString();
        }
        newRoot.addProperty("blank_tm_item_name", this.blank_tm_item_name);
        if (root.has("blank_tm_item_lore")) {
            this.blank_tm_item_lore.clear();
            lore = root.get("blank_tm_item_lore").getAsJsonArray();
            for (JsonElement element : lore) {
                this.blank_tm_item_lore.add(element.getAsString());
            }
        }
        lore = new JsonArray();
        for (String line : this.blank_tm_item_lore) {
            lore.add(line);
        }
        newRoot.add("blank_tm_item_lore", (JsonElement)lore);
        if (root.has("tr_base_item")) {
            this.tr_base_item = root.get("tr_base_item").getAsString();
        }
        newRoot.addProperty("tr_base_item", this.tr_base_item);
        if (root.has("tr_item_name")) {
            this.tr_item_name = root.get("tr_item_name").getAsString();
        }
        newRoot.addProperty("tr_item_name", this.tr_item_name);
        if (root.has("tr_item_lore")) {
            this.tr_item_lore.clear();
            lore = root.get("tr_item_lore").getAsJsonArray();
            for (JsonElement element : lore) {
                this.tr_item_lore.add(element.getAsString());
            }
        }
        lore = new JsonArray();
        for (String line : this.tr_item_lore) {
            lore.add(line);
        }
        newRoot.add("tr_item_lore", (JsonElement)lore);
        if (root.has("blank_tr_item_name")) {
            this.blank_tr_item_name = root.get("blank_tr_item_name").getAsString();
        }
        newRoot.addProperty("blank_tr_item_name", this.blank_tr_item_name);
        if (root.has("blank_tr_item_lore")) {
            this.blank_tr_item_lore.clear();
            lore = root.get("blank_tr_item_lore").getAsJsonArray();
            for (JsonElement element : lore) {
                this.blank_tr_item_lore.add(element.getAsString());
            }
        }
        lore = new JsonArray();
        for (String line : this.blank_tr_item_lore) {
            lore.add(line);
        }
        newRoot.add("blank_tr_item_lore", (JsonElement)lore);
        if (root.has("gui_title")) {
            this.gui_title = root.get("gui_title").getAsString();
        }
        newRoot.addProperty("gui_title", this.gui_title);
        if (root.has("move_learned_overlay")) {
            this.move_learned_overlay = root.get("move_learned_overlay").getAsString();
        }
        newRoot.addProperty("move_learned_overlay", this.move_learned_overlay);
        if (root.has("unable_to_learn_overlay")) {
            this.unable_to_learn_overlay = root.get("unable_to_learn_overlay").getAsString();
        }
        newRoot.addProperty("unable_to_learn_overlay", this.unable_to_learn_overlay);
        if (root.has("already_learned_overlay")) {
            this.already_learned_overlay = root.get("already_learned_overlay").getAsString();
        }
        newRoot.addProperty("already_learned_overlay", this.already_learned_overlay);
        if (root.has("prefix")) {
            this.prefix = root.get("prefix").getAsString();
        }
        newRoot.addProperty("prefix", this.prefix);
        if (root.has("reload_message")) {
            this.reload_message = root.get("reload_message").getAsString();
        }
        newRoot.addProperty("reload_message", this.reload_message);
        if (root.has("tm_give_message")) {
            this.tm_give_message = root.get("tm_give_message").getAsString();
        }
        newRoot.addProperty("tm_give_message", this.tm_give_message);
        if (root.has("tr_give_message")) {
            this.tr_give_message = root.get("tr_give_message").getAsString();
        }
        newRoot.addProperty("tr_give_message", this.tr_give_message);
        JsonObject filterOptions = new JsonObject();
        if (root.has("filter_options")) {
            filterOptions = root.get("filter_options").getAsJsonObject();
        }
        if (filterOptions.has("auto_exclude_z_moves")) {
            this.autoExcludeZMoves = filterOptions.get("auto_exclude_z_moves").getAsBoolean();
        }
        filterOptions.remove("auto_exclude_z_moves");
        filterOptions.addProperty("auto_exclude_z_moves", Boolean.valueOf(this.autoExcludeZMoves));
        if (filterOptions.has("auto_exclude_max_moves")) {
            this.autoExcludeMaxMoves = filterOptions.get("auto_exclude_max_moves").getAsBoolean();
        }
        filterOptions.remove("auto_exclude_max_moves");
        filterOptions.addProperty("auto_exclude_max_moves", Boolean.valueOf(this.autoExcludeMaxMoves));
        if (filterOptions.has("auto_exclude_gmax_moves")) {
            this.autoExcludeGMaxMoves = filterOptions.get("auto_exclude_gmax_moves").getAsBoolean();
        }
        filterOptions.remove("auto_exclude_gmax_moves");
        filterOptions.addProperty("auto_exclude_gmax_moves", Boolean.valueOf(this.autoExcludeGMaxMoves));
        if (filterOptions.has("z_moves")) {
            this.zMoves = filterOptions.getAsJsonArray("z_moves").asList().stream().map(JsonElement::getAsString).toList();
        }
        filterOptions.remove("z_moves");
        JsonArray zMovesArr = new JsonArray();
        for (String string : this.zMoves) {
            zMovesArr.add(string);
        }
        filterOptions.add("z_moves", (JsonElement)zMovesArr);
        if (filterOptions.has("max_moves")) {
            this.maxMoves = filterOptions.getAsJsonArray("max_moves").asList().stream().map(JsonElement::getAsString).toList();
        }
        filterOptions.remove("max_moves");
        JsonArray maxMovesArr = new JsonArray();
        for (String string : this.maxMoves) {
            maxMovesArr.add(string);
        }
        filterOptions.add("max_moves", (JsonElement)maxMovesArr);
        if (filterOptions.has("gmax_moves")) {
            this.gmaxMoves = filterOptions.getAsJsonArray("gmax_moves").asList().stream().map(JsonElement::getAsString).toList();
        }
        filterOptions.remove("gmax_moves");
        JsonArray jsonArray = new JsonArray();
        for (String move : this.gmaxMoves) {
            jsonArray.add(move);
        }
        filterOptions.add("gmax_moves", (JsonElement)jsonArray);
        newRoot.add("filter_options", (JsonElement)filterOptions);
        configFile.delete();
        configFile.createNewFile();
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        FileWriter writer = new FileWriter(configFile);
        gson.toJson((JsonElement)newRoot, (Appendable)writer);
        ((Writer)writer).close();
    }
}

