/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.player;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.netty.channel.ChannelHelper;
import com.github.retrooper.packetevents.protocol.ConnectionState;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.protocol.world.BoundingBox;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerKeepAlive;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPing;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWindowConfirmation;
import io.netty.channel.Channel;
import java.lang.reflect.Field;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import me.caseload.knockbacksync.Base;
import me.caseload.knockbacksync.command.subcommand.ToggleOffGroundSubcommand;
import me.caseload.knockbacksync.event.KBSyncEventHandler;
import me.caseload.knockbacksync.event.events.ConfigReloadEvent;
import me.caseload.knockbacksync.event.events.ToggleOnOffEvent;
import me.caseload.knockbacksync.manager.CombatManager;
import me.caseload.knockbacksync.manager.ConfigManager;
import me.caseload.knockbacksync.player.JitterCalculator;
import me.caseload.knockbacksync.player.PingStrategy;
import me.caseload.knockbacksync.player.PlatformPlayer;
import me.caseload.knockbacksync.scheduler.AbstractTaskHandle;
import me.caseload.knockbacksync.scheduler.NettyTaskHandle;
import me.caseload.knockbacksync.util.MathUtil;
import me.caseload.knockbacksync.util.data.Pair;
import me.caseload.knockbacksync.world.PlatformWorld;
import me.caseload.knockbacksync.world.raytrace.FluidHandling;
import me.caseload.knockbacksync.world.raytrace.RayTraceResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerData {
    private static final short MAIN_THREAD_TRANSACTION_ID = 31407;
    private static final short NETTY_THREAD_TRANSACTION_ID = 31408;
    public static final long PING_OFFSET = 25L;
    private static Field playerField;
    public final Queue<Pair<Integer, Long>> transactionsSent = new ConcurrentLinkedQueue<Pair<Integer, Long>>();
    public final Queue<Pair<Long, Long>> keepaliveMap = new ConcurrentLinkedQueue<Pair<Long, Long>>();
    public final User user;
    private final PlatformPlayer platformPlayer;
    private final UUID uuid;
    @NotNull
    private final Random random = new Random();
    public long lastKeepAliveID = 0L;
    private final JitterCalculator jitterCalculator = new JitterCalculator();
    private double jitter;
    @Nullable
    private AbstractTaskHandle combatTask;
    @NotNull
    private final Object combatTaskLock = new Object();
    @Nullable
    private Double ping;
    @Nullable
    private Double previousPing;
    @Nullable
    private Double verticalVelocity;
    @Nullable
    private Integer lastDamageTicks;
    private double gravityAttribute = 0.08;
    private double knockbackResistanceAttribute = 0.0;
    public PingStrategy pingStrategy;

    public PlayerData(User user, PlatformPlayer platformPlayer) {
        this.uuid = platformPlayer.getUUID();
        this.user = user;
        this.platformPlayer = platformPlayer;
        this.pingStrategy = this.loadPingStrategy(Base.INSTANCE.getConfigManager());
    }

    public double getNotNullPing() {
        return this.ping != null ? this.ping : (double)this.platformPlayer.getPing();
    }

    public double getNotNullPreviousPing() {
        return this.previousPing != null ? this.previousPing : (double)this.platformPlayer.getPing();
    }

    public double getCompensatedPing() {
        double previousPing;
        double ping = this.getNotNullPing();
        double spikeCompensatedPing = ping - (previousPing = this.getNotNullPreviousPing()) > (double)Base.INSTANCE.getConfigManager().getSpikeThreshold() ? previousPing : ping;
        return Math.max(1.0, spikeCompensatedPing - 25.0);
    }

    public int getCompensatedTicks() {
        return (int)Math.ceil(this.getCompensatedPing() * (double)Base.INSTANCE.getTickRate() / 1000.0);
    }

    public int getTicks() {
        return (int)Math.ceil(this.getNotNullPing() * (double)Base.INSTANCE.getTickRate() / 1000.0);
    }

    public boolean isSpike() {
        return this.getNotNullPing() - this.getNotNullPreviousPing() > (double)Base.INSTANCE.getConfigManager().getSpikeThreshold();
    }

    public void sendPing(boolean async) {
        if (this.user == null || this.user.getEncoderState() != ConnectionState.PLAY) {
            return;
        }
        switch (this.pingStrategy) {
            case KEEPALIVE: {
                long keepAliveID;
                long l = keepAliveID = async ? 31408L : 31407L;
                if (async) {
                    ChannelHelper.runInEventLoop((Object)this.user.getChannel(), () -> this.user.sendPacket((PacketWrapper)new WrapperPlayServerKeepAlive(keepAliveID)));
                    break;
                }
                this.user.sendPacket((PacketWrapper)new WrapperPlayServerKeepAlive(keepAliveID));
                break;
            }
            case TRANSACTION: {
                short pingTransactionID = async ? (short)31408 : 31407;
                Object packet = PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_17) ? new WrapperPlayServerPing((int)pingTransactionID) : new WrapperPlayServerWindowConfirmation(0, pingTransactionID, false);
                if (async) {
                    ChannelHelper.runInEventLoop((Object)this.user.getChannel(), () -> this.lambda$sendPing$1((PacketWrapper)packet));
                    break;
                }
                this.user.writePacket((PacketWrapper)packet);
            }
        }
    }

    public boolean isOnGroundClientSide(double verticalVelocity, double distanceToGround) {
        int tMax;
        int n = tMax = verticalVelocity > 0.0 ? MathUtil.calculateTimeToMaxVelocity(verticalVelocity, this.gravityAttribute) : 0;
        if (tMax == -1) {
            return false;
        }
        double mH = verticalVelocity > 0.0 ? MathUtil.calculateDistanceTraveled(verticalVelocity, tMax, this.gravityAttribute) : 0.0;
        int tFall = MathUtil.calculateFallTime(verticalVelocity, mH + distanceToGround, this.gravityAttribute);
        if (tFall == -1) {
            return false;
        }
        return tMax + tFall - this.getCompensatedTicks() <= 0 && distanceToGround <= 1.3;
    }

    public boolean isOffGroundSyncEnabled() {
        return ToggleOffGroundSubcommand.offGroundSyncEnabled;
    }

    public double getCompensatedOffGroundVelocity() {
        return MathUtil.getCompensatedVerticalVelocity(this.platformPlayer.getVelocity().getY(), this.getGravityAttribute(), this.getTicks());
    }

    public double getDistanceToGround() {
        double collisionDist = 5.0;
        PlatformWorld world = this.platformPlayer.getWorld();
        for (Vector3d corner : this.getBBCorners()) {
            RayTraceResult result = world.rayTraceBlocks(corner, new Vector3d(0.0, -1.0, 0.0), 5.0, FluidHandling.NONE, true);
            if (result == null || result.getHitBlock() == null) continue;
            collisionDist = Math.min(collisionDist, corner.getY() - (double)result.getHitBlockPosition().getY());
        }
        return collisionDist - 1.0;
    }

    private Vector3d[] getBBCorners() {
        BoundingBox boundingBox = this.platformPlayer.getBoundingBox();
        Vector3d location = this.platformPlayer.getLocation();
        double adjustment = 0.01;
        return new Vector3d[]{new Vector3d(boundingBox.getMinX() + adjustment, location.getY(), boundingBox.getMinZ() + adjustment), new Vector3d(boundingBox.getMinX() + adjustment, location.getY(), boundingBox.getMaxZ() - adjustment), new Vector3d(boundingBox.getMaxX() - adjustment, location.getY(), boundingBox.getMinZ() + adjustment), new Vector3d(boundingBox.getMaxX() - adjustment, location.getY(), boundingBox.getMaxZ() - adjustment)};
    }

    public double calculateVerticalVelocity(PlatformPlayer attacker) {
        double yAxis;
        double d = yAxis = attacker.getAttackCooldown() > 0.848 ? 0.4 : 0.36080000519752503;
        if (!attacker.isSprinting()) {
            yAxis = 0.36080000519752503;
            double resistanceFactor = 0.04000000119 * this.knockbackResistanceAttribute * 10.0;
            yAxis -= resistanceFactor;
        }
        if (attacker.getMainHandKnockbackLevel() > 0) {
            yAxis = 0.4;
        }
        return yAxis;
    }

    public void updateCombat() {
        Channel channel = (Channel)this.user.getChannel();
        channel.eventLoop().execute(() -> {
            if (this.combatTask != null) {
                this.combatTask.cancel();
            }
            this.combatTask = this.newCombatTask(channel);
            CombatManager.addPlayer(this.user);
        });
    }

    public void quitCombat(boolean async) {
        Channel channel = (Channel)this.user.getChannel();
        Runnable runnable = () -> {
            if (this.combatTask != null) {
                this.combatTask.cancel();
                this.combatTask = null;
            }
            CombatManager.removePlayer(this.user);
        };
        if (async) {
            channel.eventLoop().execute(runnable);
        } else {
            runnable.run();
        }
    }

    @NotNull
    private AbstractTaskHandle newCombatTask(Channel channel) {
        return new NettyTaskHandle(channel.eventLoop().schedule(() -> this.quitCombat(false), this.convertTicksToMilliseconds(Base.INSTANCE.getConfigManager().getCombatTimer()), TimeUnit.MILLISECONDS));
    }

    public ClientVersion getClientVersion() {
        if (this.user == null) {
            return ClientVersion.UNKNOWN;
        }
        ClientVersion ver = this.user.getClientVersion();
        if (ver == null) {
            return ClientVersion.getById((int)PacketEvents.getAPI().getServerManager().getVersion().getProtocolVersion());
        }
        return ver;
    }

    public long getKeepAliveSendTime() {
        return this.lastKeepAliveID;
    }

    public boolean didWeSendThatPacket(long receivedId) {
        return receivedId == 31408L || receivedId == 31407L;
    }

    @KBSyncEventHandler
    public void onToggledEvent(ToggleOnOffEvent event) {
        if (!event.getStatus()) {
            this.transactionsSent.clear();
            this.keepaliveMap.clear();
        }
    }

    @KBSyncEventHandler
    public void onConfigReloadEvent(ConfigReloadEvent event) {
        this.pingStrategy = this.loadPingStrategy(event.getConfigManager());
    }

    private PingStrategy loadPingStrategy(ConfigManager configManager) {
        String pingStrategy;
        switch (pingStrategy = configManager.getConfigWrapper().getString("ping_strategy", "KEEPALIVE")) {
            case "KEEPALIVE": {
                return PingStrategy.KEEPALIVE;
            }
            case "PING": 
            case "TRANSACTION": {
                return PingStrategy.TRANSACTION;
            }
        }
        throw new IllegalStateException("Unknown ping_strategy: " + pingStrategy);
    }

    private long convertTicksToMilliseconds(long ticks) {
        return ticks * 50L;
    }

    @Generated
    public Queue<Pair<Integer, Long>> getTransactionsSent() {
        return this.transactionsSent;
    }

    @Generated
    public Queue<Pair<Long, Long>> getKeepaliveMap() {
        return this.keepaliveMap;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public PlatformPlayer getPlatformPlayer() {
        return this.platformPlayer;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    @Generated
    public Random getRandom() {
        return this.random;
    }

    @Generated
    public long getLastKeepAliveID() {
        return this.lastKeepAliveID;
    }

    @Generated
    public double getJitter() {
        return this.jitter;
    }

    @Nullable
    @Generated
    public AbstractTaskHandle getCombatTask() {
        return this.combatTask;
    }

    @NotNull
    @Generated
    public Object getCombatTaskLock() {
        return this.combatTaskLock;
    }

    @Nullable
    @Generated
    public Double getPing() {
        return this.ping;
    }

    @Nullable
    @Generated
    public Double getPreviousPing() {
        return this.previousPing;
    }

    @Nullable
    @Generated
    public Double getVerticalVelocity() {
        return this.verticalVelocity;
    }

    @Nullable
    @Generated
    public Integer getLastDamageTicks() {
        return this.lastDamageTicks;
    }

    @Generated
    public double getGravityAttribute() {
        return this.gravityAttribute;
    }

    @Generated
    public double getKnockbackResistanceAttribute() {
        return this.knockbackResistanceAttribute;
    }

    @Generated
    public PingStrategy getPingStrategy() {
        return this.pingStrategy;
    }

    @Generated
    public JitterCalculator getJitterCalculator() {
        return this.jitterCalculator;
    }

    @Generated
    public void setJitter(double jitter) {
        this.jitter = jitter;
    }

    @Generated
    public void setPing(@Nullable Double ping) {
        this.ping = ping;
    }

    @Generated
    public void setPreviousPing(@Nullable Double previousPing) {
        this.previousPing = previousPing;
    }

    @Generated
    public void setVerticalVelocity(@Nullable Double verticalVelocity) {
        this.verticalVelocity = verticalVelocity;
    }

    @Generated
    public void setLastDamageTicks(@Nullable Integer lastDamageTicks) {
        this.lastDamageTicks = lastDamageTicks;
    }

    @Generated
    public void setGravityAttribute(double gravityAttribute) {
        this.gravityAttribute = gravityAttribute;
    }

    @Generated
    public void setKnockbackResistanceAttribute(double knockbackResistanceAttribute) {
        this.knockbackResistanceAttribute = knockbackResistanceAttribute;
    }

    private /* synthetic */ void lambda$sendPing$1(PacketWrapper packet) {
        this.user.writePacket(packet);
    }

    static {
        try {
            switch (Base.INSTANCE.getPlatform()) {
                case BUKKIT: 
                case FOLIA: {
                    Class<?> bukkitPlayerClass = Class.forName("me.caseload.knockbacksync.player.BukkitPlayer");
                    playerField = bukkitPlayerClass.getDeclaredField("bukkitPlayer");
                    break;
                }
                case FABRIC: {
                    Class<?> fabricPlayerClass = Class.forName("me.caseload.knockbacksync.player.FabricPlayer");
                    playerField = fabricPlayerClass.getDeclaredField("fabricPlayer");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected platform: " + String.valueOf((Object)Base.INSTANCE.getPlatform()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        playerField.setAccessible(true);
    }
}

