/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.listener.packetevents;

import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientKeepAlive;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPong;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientWindowConfirmation;
import java.util.Queue;
import me.caseload.knockbacksync.Base;
import me.caseload.knockbacksync.manager.PlayerDataManager;
import me.caseload.knockbacksync.player.PingStrategy;
import me.caseload.knockbacksync.player.PlayerData;
import me.caseload.knockbacksync.util.data.Pair;

public class PingReceiveListener
extends PacketListenerAbstract {
    public PingReceiveListener() {
        super(PacketListenerPriority.LOWEST);
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        PacketTypeCommon packetType = event.getPacketType();
        User user = event.getUser();
        if (user == null) {
            return;
        }
        PlayerData playerData = PlayerDataManager.getPlayerData(user);
        if (playerData == null) {
            return;
        }
        if (playerData.pingStrategy == PingStrategy.KEEPALIVE && packetType == PacketType.Play.Client.KEEP_ALIVE) {
            WrapperPlayClientKeepAlive keepAlive = new WrapperPlayClientKeepAlive(event);
            long receivedId = keepAlive.getId();
            this.handlePingCalculationPackets(event, playerData, receivedId, playerData.keepaliveMap);
        } else if (playerData.pingStrategy == PingStrategy.TRANSACTION && packetType == PacketType.Play.Client.PONG) {
            WrapperPlayClientPong pong = new WrapperPlayClientPong(event);
            int id = pong.getId();
            this.handlePingCalculationPackets(event, playerData, id, playerData.transactionsSent);
        } else if (playerData.pingStrategy == PingStrategy.TRANSACTION && packetType == PacketType.Play.Client.WINDOW_CONFIRMATION) {
            WrapperPlayClientWindowConfirmation windowConfirmation = new WrapperPlayClientWindowConfirmation(event);
            short id = windowConfirmation.getActionId();
            this.handlePingCalculationPackets(event, playerData, id, playerData.transactionsSent);
        }
    }

    private <T extends Number> void handlePingCalculationPackets(PacketReceiveEvent event, PlayerData playerData, long id, Queue<Pair<T, Long>> packetSentList) {
        if (playerData.didWeSendThatPacket(id)) {
            event.setCancelled(true);
        }
        if (!Base.INSTANCE.getConfigManager().isToggled()) {
            return;
        }
        Pair<T, Long> data = null;
        int cleared = 0;
        do {
            data = packetSentList.poll();
            ++cleared;
            if (data == null) break;
            long pingNanos = System.nanoTime() - data.getSecond();
            double diffMillisDouble = (double)pingNanos / 1000000.0;
            playerData.setPreviousPing(playerData.getPing());
            playerData.setPing(diffMillisDouble);
            playerData.getJitterCalculator().addPing(pingNanos);
            double jitter = playerData.getJitterCalculator().calculateJitter();
            playerData.setJitter(jitter);
        } while (((Number)data.getFirst()).longValue() != id);
    }
}

