/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.listener.packetevents;

import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerKeepAlive;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPing;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWindowConfirmation;
import java.util.UUID;
import me.caseload.knockbacksync.Base;
import me.caseload.knockbacksync.manager.PlayerDataManager;
import me.caseload.knockbacksync.player.PingStrategy;
import me.caseload.knockbacksync.player.PlayerData;
import me.caseload.knockbacksync.util.data.Pair;

public class PingSendListener
extends PacketListenerAbstract {
    public PingSendListener() {
        super(PacketListenerPriority.MONITOR);
    }

    public void onPacketSend(PacketSendEvent event) {
        if (!Base.INSTANCE.getConfigManager().isToggled()) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        PacketTypeCommon packetType = event.getPacketType();
        UUID playerUUID = event.getUser().getUUID();
        if (playerUUID == null) {
            return;
        }
        PlayerData playerData = PlayerDataManager.getPlayerData(event.getUser());
        if (playerData == null) {
            return;
        }
        if (playerData.pingStrategy == PingStrategy.KEEPALIVE && packetType.equals((Object)PacketType.Play.Server.KEEP_ALIVE)) {
            WrapperPlayServerKeepAlive keepAlive = new WrapperPlayServerKeepAlive(event);
            long id = keepAlive.getId();
            playerData.keepaliveMap.add(new Pair<Long, Long>(id, System.nanoTime()));
        } else if (playerData.pingStrategy == PingStrategy.TRANSACTION && packetType.equals((Object)PacketType.Play.Server.PING)) {
            WrapperPlayServerPing ping = new WrapperPlayServerPing(event);
            int id = ping.getId();
            playerData.transactionsSent.add(new Pair<Integer, Long>(id, System.nanoTime()));
        } else if (playerData.pingStrategy == PingStrategy.TRANSACTION && packetType.equals((Object)PacketType.Play.Server.WINDOW_CONFIRMATION)) {
            WrapperPlayServerWindowConfirmation confirmation = new WrapperPlayServerWindowConfirmation(event);
            short id = confirmation.getActionId();
            playerData.transactionsSent.add(new Pair<Integer, Long>(Integer.valueOf(id), System.nanoTime()));
        }
    }
}

