/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.scheduler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import me.caseload.knockbacksync.FabricLoaderMod;
import me.caseload.knockbacksync.scheduler.AbstractTaskHandle;
import me.caseload.knockbacksync.scheduler.FabricTaskHandle;
import me.caseload.knockbacksync.scheduler.SchedulerAdapter;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.server.MinecraftServer;

public class FabricSchedulerAdapter
implements SchedulerAdapter {
    private final Map<ScheduledTask, Runnable> taskMap = new HashMap<ScheduledTask, Runnable>();
    private final Map<Thread, Runnable> asyncTasks = new HashMap<Thread, Runnable>();

    public FabricSchedulerAdapter() {
        ServerTickEvents.END_SERVER_TICK.register(this::handleTasks);
    }

    private void handleTasks(MinecraftServer server) {
        Iterator<ScheduledTask> iterator = this.taskMap.keySet().iterator();
        while (iterator.hasNext()) {
            ScheduledTask task = iterator.next();
            if ((long)server.method_3780() < task.nextRunTick) continue;
            task.task.run();
            if (task.isPeriodic) {
                task.nextRunTick = (long)server.method_3780() + task.period;
                continue;
            }
            iterator.remove();
        }
    }

    @Override
    public AbstractTaskHandle runTask(Runnable task) {
        ScheduledTask scheduledTask = new ScheduledTask(task, FabricLoaderMod.getServer().method_3780(), 0L, false);
        Runnable cancellationTask = () -> this.taskMap.remove(scheduledTask);
        this.taskMap.put(scheduledTask, cancellationTask);
        return new FabricTaskHandle(cancellationTask);
    }

    @Override
    public AbstractTaskHandle runTaskAsynchronously(Runnable task) {
        Thread thread = new Thread(task);
        Runnable cancellationTask = () -> {
            thread.interrupt();
            this.asyncTasks.remove(thread);
        };
        this.asyncTasks.put(thread, cancellationTask);
        thread.start();
        return new FabricTaskHandle(cancellationTask);
    }

    @Override
    public AbstractTaskHandle runTaskLater(Runnable task, long delayTicks) {
        ScheduledTask scheduledTask = new ScheduledTask(task, (long)FabricLoaderMod.getServer().method_3780() + delayTicks, 0L, false);
        Runnable cancellationTask = () -> this.taskMap.remove(scheduledTask);
        this.taskMap.put(scheduledTask, cancellationTask);
        return new FabricTaskHandle(cancellationTask);
    }

    @Override
    public AbstractTaskHandle runTaskTimer(Runnable task, long delayTicks, long periodTicks) {
        ScheduledTask scheduledTask = new ScheduledTask(task, (long)FabricLoaderMod.getServer().method_3780() + delayTicks, periodTicks, true);
        Runnable cancellationTask = () -> this.taskMap.remove(scheduledTask);
        this.taskMap.put(scheduledTask, cancellationTask);
        return new FabricTaskHandle(cancellationTask);
    }

    @Override
    public AbstractTaskHandle runTaskLaterAsynchronously(Runnable task, long delay) {
        Thread thread = new Thread(() -> {
            try {
                Thread.sleep(delay * 50L);
                task.run();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        Runnable cancellationTask = () -> {
            thread.interrupt();
            this.asyncTasks.remove(thread);
        };
        this.asyncTasks.put(thread, cancellationTask);
        thread.start();
        return new FabricTaskHandle(cancellationTask);
    }

    @Override
    public AbstractTaskHandle runTaskTimerAsynchronously(Runnable task, long delay, long period) {
        Thread thread = new Thread(() -> {
            try {
                Thread.sleep(delay * 50L);
                while (!Thread.currentThread().isInterrupted()) {
                    task.run();
                    Thread.sleep(period * 50L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        Runnable cancellationTask = () -> {
            thread.interrupt();
            this.asyncTasks.remove(thread);
        };
        this.asyncTasks.put(thread, cancellationTask);
        thread.start();
        return new FabricTaskHandle(cancellationTask);
    }

    @Override
    public void shutdown() {
        ArrayList<Runnable> tasksToExecute = new ArrayList<Runnable>();
        tasksToExecute.addAll(this.taskMap.values());
        tasksToExecute.addAll(this.asyncTasks.values());
        this.taskMap.clear();
        this.asyncTasks.clear();
        for (Runnable task : tasksToExecute) {
            task.run();
        }
    }

    private static class ScheduledTask {
        final Runnable task;
        final long period;
        final boolean isPeriodic;
        long nextRunTick;

        ScheduledTask(Runnable task, long nextRunTick, long period, boolean isPeriodic) {
            this.task = task;
            this.nextRunTick = nextRunTick;
            this.period = period;
            this.isPeriodic = isPeriodic;
        }
    }
}

