/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.sender;

import java.util.Objects;
import java.util.UUID;
import me.caseload.knockbacksync.Base;
import me.caseload.knockbacksync.sender.AbstractSender;
import me.caseload.knockbacksync.sender.Sender;

public abstract class SenderFactory<P extends Base, T>
implements AutoCloseable {
    private final P plugin;

    public SenderFactory(P plugin) {
        this.plugin = plugin;
    }

    protected P getPlugin() {
        return this.plugin;
    }

    protected abstract UUID getUniqueId(T var1);

    protected abstract String getName(T var1);

    protected abstract void sendMessage(T var1, String var2);

    protected abstract boolean hasPermission(T var1, String var2);

    protected abstract boolean hasPermission(T var1, String var2, boolean var3);

    protected abstract void performCommand(T var1, String var2);

    protected abstract boolean isConsole(T var1);

    protected boolean shouldSplitNewlines(T sender) {
        return this.isConsole(sender);
    }

    public final Sender wrap(T sender) {
        Objects.requireNonNull(sender, "sender");
        return new AbstractSender<T>((Base)this.plugin, this, sender);
    }

    public final T unwrap(Sender sender) {
        Objects.requireNonNull(sender, "sender");
        return (T)sender.getSender();
    }
}

