/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.util;

import java.util.HashMap;
import java.util.Map;
import me.caseload.knockbacksync.Base;
import me.caseload.knockbacksync.ConfigWrapper;
import me.caseload.knockbacksync.mixin.UpdateIntervalAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3898;

public class CustomUpdateIntervals {
    private static final Map<String, Integer> entityIntervals = new HashMap<String, Integer>();

    public static void setInterval(String entityType, int interval) {
        entityIntervals.put(entityType, interval);
    }

    public static int getInterval(String entityType, int defaultInterval) {
        return entityIntervals.getOrDefault(entityType, defaultInterval);
    }

    public static void clear() {
        entityIntervals.clear();
    }

    public static void updateIntervals(class_3218 level, Map<String, Integer> entityIntervals) {
        for (class_1297 entity : level.method_27909()) {
            class_3898.class_3208 serverEntity;
            String entityType = entity.method_5864().method_40124().method_55840();
            if (!entityIntervals.containsKey(entityType) || (serverEntity = (class_3898.class_3208)((class_3215)entity.method_73183().method_8398()).field_17254.field_18242.get(entity.method_5628())) == null) continue;
            ((UpdateIntervalAccessor)serverEntity).setUpdateInterval(entityIntervals.get(entityType));
        }
    }

    public static Map<String, Integer> loadEntityIntervalsFromConfig() {
        String basePath;
        HashMap<String, Integer> intervals = new HashMap<String, Integer>();
        ConfigWrapper config = Base.INSTANCE.getConfigManager().getConfigWrapper();
        if (config.contains(basePath = "entity_update_intervals")) {
            for (String entityType : config.getKeys(basePath)) {
                int interval = config.getInt(basePath + "." + entityType, -1);
                if (interval <= 0) continue;
                intervals.put(entityType, interval);
            }
        }
        return intervals;
    }
}

