/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.caseload.knockbacksync.util.NumberConversions;

public class ConfigWrapper {
    private final Map<String, Object> configMap;

    public ConfigWrapper(Map<String, Object> configMap) {
        this.configMap = configMap;
    }

    public String getString(String path, String def) {
        Object value = this.getValue(path);
        return value instanceof String ? (String)value : def;
    }

    public boolean getBoolean(String path, boolean def) {
        Object value = this.getValue(path);
        return value instanceof Boolean ? (Boolean)value : def;
    }

    public int getInt(String path, int def) {
        Object value = this.getValue(path);
        return NumberConversions.toInt(value, def);
    }

    public long getLong(String path, long def) {
        Object value = this.getValue(path);
        return NumberConversions.toLong(value, def);
    }

    public void set(String path, Object value) {
        this.setValue(path, value);
    }

    private Object getValue(String path) {
        String[] parts = path.split("\\.");
        Object current = this.configMap;
        for (String part : parts) {
            if (!(current instanceof Map)) {
                return null;
            }
            current = current.get(part);
        }
        return current;
    }

    private void setValue(String path, Object value) {
        String[] parts = path.split("\\.");
        Map current = this.configMap;
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (!current.containsKey(part) || !(current.get(part) instanceof Map)) {
                current.put((String)part, new HashMap());
            }
            current = (Map)current.get(part);
        }
        current.put((String)parts[parts.length - 1], (Object)value);
    }

    public boolean contains(String path) {
        return this.getValue(path) != null;
    }

    public Object get(String path) {
        return this.getValue(path);
    }

    public Set<String> getKeys(String path) {
        Object value = this.getValue(path);
        if (value instanceof Map) {
            return ((Map)value).keySet();
        }
        return new HashSet<String>();
    }
}

