/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.command.subcommand;

import java.util.function.Predicate;
import me.caseload.knockbacksync.Base;
import me.caseload.knockbacksync.ConfigWrapper;
import me.caseload.knockbacksync.command.generic.BuilderCommand;
import me.caseload.knockbacksync.event.KBSyncEventHandler;
import me.caseload.knockbacksync.event.events.ConfigReloadEvent;
import me.caseload.knockbacksync.sender.Sender;
import me.caseload.knockbacksync.util.ChatUtil;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.permission.PredicatePermission;

public class ToggleOffGroundSubcommand
implements BuilderCommand {
    public static boolean offGroundSyncEnabled = true;
    private String offGroundSyncEnableMessage;
    private String offGroundSyncDisableMessage;

    public ToggleOffGroundSubcommand() {
        this.loadConfigSettings();
    }

    @Override
    public void register(CommandManager<Sender> manager) {
        manager.command(manager.commandBuilder("knockbacksync", new String[]{"kbsync", "kbs"}).literal("toggleoffground", new String[0]).permission(sender -> {
            String permission = "knockbacksync.toggleoffground";
            Predicate<Sender> senderPredicate = s -> s.hasPermission("knockbacksync.toggleoffground", false);
            return PredicatePermission.of(senderPredicate).testPermission(sender);
        }).handler(commandContext -> {
            offGroundSyncEnabled = !offGroundSyncEnabled;
            Base.INSTANCE.getConfigManager().getConfigWrapper().set("enable_offground_synchronization", offGroundSyncEnabled);
            Base.INSTANCE.getConfigManager().saveConfig();
            String message = ChatUtil.translateAlternateColorCodes('&', offGroundSyncEnabled ? this.offGroundSyncEnableMessage : this.offGroundSyncDisableMessage);
            ((Sender)commandContext.sender()).sendMessage(message);
        }));
    }

    @KBSyncEventHandler
    public void onConfigReloadEvent(ConfigReloadEvent event) {
        this.loadConfigSettings();
    }

    private void loadConfigSettings() {
        ConfigWrapper configWrapper = Base.INSTANCE.getConfigManager().getConfigWrapper();
        offGroundSyncEnabled = configWrapper.getBoolean("settings.offground.enabled", true);
        this.offGroundSyncEnableMessage = configWrapper.getString("messages.offground.enable", "&aSuccessfully enabled offground synchronization.");
        this.offGroundSyncDisableMessage = configWrapper.getString("messages.offground.disable", "&cSuccessfully disabled offground synchronization.");
    }
}

