/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.config;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import lombok.Generated;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlConfiguration {
    private final File file;
    private final Yaml yaml;
    private Map<String, Object> data;
    private String fileContents;

    public YamlConfiguration(File file) {
        this.file = file;
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        options.setWidth(Integer.MAX_VALUE);
        this.yaml = new Yaml(options);
    }

    public void load() throws IOException {
        if (!this.file.exists()) {
            this.data = new LinkedHashMap<String, Object>();
            return;
        }
        this.fileContents = new String(Files.readAllBytes(this.file.toPath()), StandardCharsets.UTF_8);
        this.data = (Map)this.yaml.load(this.fileContents);
        if (this.data == null) {
            this.data = new LinkedHashMap<String, Object>();
        }
    }

    public void save() throws IOException {
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            this.file.createNewFile();
        }
        String dump = this.yaml.dump(this.data);
        if (this.fileContents != null) {
            Map<String, YamlElement> oldElements = this.parseYaml(this.fileContents);
            Map<String, YamlElement> newElements = this.parseYaml(dump);
            StringBuilder result = new StringBuilder();
            this.buildOutput(oldElements, newElements, result);
            dump = result.toString();
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(this.file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            writer.write(dump);
        }
    }

    private Map<String, YamlElement> parseYaml(String content) {
        String[] lines;
        LinkedHashMap<String, YamlElement> elements = new LinkedHashMap<String, YamlElement>();
        Stack<YamlElement> stack = new Stack<YamlElement>();
        for (String line : lines = content.split("\n")) {
            if (line.trim().isEmpty()) continue;
            int indent = this.getIndentation(line);
            YamlElement element = new YamlElement(line, indent);
            while (!stack.isEmpty() && ((YamlElement)stack.peek()).indent >= indent) {
                stack.pop();
            }
            if (stack.isEmpty()) {
                if (!element.isComment) {
                    elements.put(element.key, element);
                } else {
                    elements.put("comment" + elements.size(), element);
                }
            } else {
                ((YamlElement)stack.peek()).children.add(element);
            }
            if (element.isComment || !element.value.isEmpty()) continue;
            stack.push(element);
        }
        return elements;
    }

    private void buildOutput(Map<String, YamlElement> oldElements, Map<String, YamlElement> newElements, StringBuilder result) {
        for (YamlElement element : oldElements.values()) {
            if (element.isComment) {
                result.append(element.value).append("\n");
                continue;
            }
            YamlElement newElement = newElements.get(element.key);
            if (newElement == null) continue;
            String indent = this.createIndent(element.indent);
            result.append(indent).append(element.key).append(":");
            if (!newElement.value.isEmpty()) {
                result.append(" ").append(newElement.value);
            }
            result.append("\n");
            if (element.children.isEmpty()) continue;
            LinkedHashMap<String, YamlElement> oldChildren = new LinkedHashMap<String, YamlElement>();
            LinkedHashMap<String, YamlElement> newChildren = new LinkedHashMap<String, YamlElement>();
            for (YamlElement child : element.children) {
                if (!child.isComment) {
                    oldChildren.put(child.key, child);
                    continue;
                }
                oldChildren.put("comment" + oldChildren.size(), child);
            }
            for (YamlElement child : newElement.children) {
                if (child.isComment) continue;
                newChildren.put(child.key, child);
            }
            this.buildOutput(oldChildren, newChildren, result);
        }
    }

    private int getIndentation(String line) {
        int indent;
        for (indent = 0; indent < line.length() && line.charAt(indent) == ' '; ++indent) {
        }
        return indent;
    }

    private String createIndent(int count) {
        StringBuilder sb = new StringBuilder(count);
        for (int i = 0; i < count; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    @Generated
    public Map<String, Object> getData() {
        return this.data;
    }

    @Generated
    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    private static class YamlElement {
        String key;
        String value;
        int indent;
        boolean isComment;
        List<YamlElement> children = new ArrayList<YamlElement>();

        YamlElement(String line, int indent) {
            this.indent = indent;
            if (line.trim().startsWith("#")) {
                this.isComment = true;
                this.value = line;
            } else {
                this.isComment = false;
                String[] parts = line.split(":", 2);
                this.key = parts[0].trim();
                this.value = parts.length > 1 ? parts[1].trim() : "";
            }
        }
    }
}

