/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.listener.packetevents;

import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPluginMessage;
import me.caseload.knockbacksync.manager.PlayerDataManager;
import me.caseload.knockbacksync.player.PlayerData;

public class ClientBrandListener
extends PacketListenerAbstract {
    String brand = "vanilla";
    boolean hasBrand = false;

    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.PLUGIN_MESSAGE) {
            WrapperPlayClientPluginMessage packet = new WrapperPlayClientPluginMessage(event);
            String channelName = packet.getChannelName();
            this.handle(channelName, packet.getData());
            PlayerData playerData = PlayerDataManager.getPlayerData(event.getUser());
            if (playerData == null) {
                return;
            }
            playerData.getPlatformPlayer().setClientBrand(this.brand);
        }
    }

    public void handle(String channel, byte[] data) {
        if (channel.equalsIgnoreCase("minecraft:brand") || channel.equals("MC|Brand")) {
            if (data.length > 64 || data.length == 0) {
                this.brand = "sent " + data.length + " bytes as brand";
            } else if (!this.hasBrand) {
                byte[] minusLength = new byte[data.length - 1];
                System.arraycopy(data, 1, minusLength, 0, minusLength.length);
                this.brand = new String(minusLength).replace(" (Velocity)", "");
            }
            this.hasBrand = true;
        }
    }
}

