/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.org.kohsuke.github;

import java.io.IOException;
import java.util.Objects;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHRepository;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHRepositoryBuilder;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHTeam;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHub;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.Requester;

public class GHCreateRepositoryBuilder
extends GHRepositoryBuilder<GHCreateRepositoryBuilder> {
    public GHCreateRepositoryBuilder(String name, GitHub root, String apiTail) {
        super(GHCreateRepositoryBuilder.class, root, null);
        ((Requester)this.requester.method("POST")).withUrlPath(apiTail, new String[0]);
        try {
            this.name(name);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public GHCreateRepositoryBuilder gitignoreTemplate(String language) throws IOException {
        return (GHCreateRepositoryBuilder)this.with("gitignore_template", language);
    }

    public GHCreateRepositoryBuilder licenseTemplate(String license) throws IOException {
        return (GHCreateRepositoryBuilder)this.with("license_template", license);
    }

    public GHCreateRepositoryBuilder autoInit(boolean enabled) throws IOException {
        return (GHCreateRepositoryBuilder)this.with("auto_init", enabled);
    }

    public GHCreateRepositoryBuilder team(GHTeam team) throws IOException {
        if (team != null) {
            return (GHCreateRepositoryBuilder)this.with("team_id", team.getId());
        }
        return this;
    }

    @Deprecated
    public GHCreateRepositoryBuilder templateRepository(boolean enabled) throws IOException {
        return (GHCreateRepositoryBuilder)this.isTemplate(enabled);
    }

    public GHCreateRepositoryBuilder owner(String owner) throws IOException {
        return (GHCreateRepositoryBuilder)this.with("owner", owner);
    }

    public GHCreateRepositoryBuilder fromTemplateRepository(String templateOwner, String templateRepo) {
        this.requester.withUrlPath("/repos/" + templateOwner + "/" + templateRepo + "/generate", new String[0]);
        return this;
    }

    public GHCreateRepositoryBuilder fromTemplateRepository(GHRepository templateRepository) {
        Objects.requireNonNull(templateRepository, "templateRepository cannot be null");
        if (!templateRepository.isTemplate()) {
            throw new IllegalArgumentException("The provided repository is not a template repository.");
        }
        return this.fromTemplateRepository(templateRepository.getOwnerName(), templateRepository.getName());
    }

    public GHRepository create() throws IOException {
        return this.done();
    }
}

