/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.player;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;

public class JitterCalculator {
    private final int SAMPLE_SIZE = 15;
    private final Queue<Long> pings = new LinkedList<Long>();

    public void addPing(long pingTime) {
        this.pings.offer(pingTime);
        if (this.pings.size() > 15) {
            this.pings.poll();
        }
    }

    public double calculateJitter() {
        if (this.pings.size() < 2) {
            return 0.0;
        }
        ArrayList<Long> sortedPings = new ArrayList<Long>(this.pings);
        Collections.sort(sortedPings);
        int q1Index = sortedPings.size() / 4;
        int q3Index = q1Index * 3;
        long q1 = (Long)sortedPings.get(q1Index);
        long q3 = (Long)sortedPings.get(q3Index);
        long iqr = q3 - q1;
        double lowerBound = (double)q1 - 1.5 * (double)iqr;
        double upperBound = (double)q3 + 1.5 * (double)iqr;
        List filteredPings = sortedPings.stream().filter(p -> (double)p.longValue() >= lowerBound && (double)p.longValue() <= upperBound).collect(Collectors.toList());
        double mean = filteredPings.stream().mapToLong(Long::longValue).average().orElse(0.0);
        double variance = filteredPings.stream().mapToDouble(p -> Math.pow((double)p.longValue() - mean, 2.0)).average().orElse(0.0);
        double stdDev = Math.sqrt(variance);
        double meanJitter = 0.0;
        Long prevPing = null;
        for (Long ping : filteredPings) {
            if (prevPing != null) {
                meanJitter += (double)Math.abs(ping - prevPing);
            }
            prevPing = ping;
        }
        meanJitter /= (double)(filteredPings.size() - 1);
        return stdDev / 1000000.0;
    }
}

