/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.org.incendo.cloud.services;

import java.util.function.Predicate;
import me.caseload.knockbacksync.shaded.io.leangen.geantyref.TypeToken;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.services.PipelineException;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.services.ServiceRepository;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.services.type.Service;
import org.checkerframework.checker.nullness.qual.NonNull;

enum ServiceFilterHandler {
    INSTANCE;


    <Context> boolean passes(@NonNull ServiceRepository.ServiceWrapper<? extends Service<Context, ?>> service, @NonNull Context context) {
        if (!service.isDefaultImplementation()) {
            for (Predicate predicate : service.filters()) {
                try {
                    if (predicate.test(context)) continue;
                    return false;
                }
                catch (Exception e) {
                    throw new PipelineException(String.format("Failed to evaluate filter '%s' for '%s'", TypeToken.get(predicate.getClass()).getType().getTypeName(), service), e);
                }
            }
        }
        return true;
    }
}

