/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.org.kohsuke.github;

import java.io.IOException;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHubClient;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHubPageIterator;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHubRequest;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHubResponse;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.PagedIterable;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.PagedIterator;

class GitHubPageContentsIterable<T>
extends PagedIterable<T> {
    private final GitHubClient client;
    private final GitHubRequest request;
    private final Class<T[]> receiverType;
    private final Consumer<T> itemInitializer;

    GitHubPageContentsIterable(GitHubClient client, GitHubRequest request, Class<T[]> receiverType, Consumer<T> itemInitializer) {
        this.client = client;
        this.request = request;
        this.receiverType = receiverType;
        this.itemInitializer = itemInitializer;
    }

    @Override
    @Nonnull
    public PagedIterator<T> _iterator(int pageSize) {
        GitHubPageIterator<T[]> iterator = GitHubPageIterator.create(this.client, this.receiverType, this.request, pageSize);
        return new GitHubPageContentsIterator(iterator, this.itemInitializer);
    }

    @Nonnull
    GitHubResponse<T[]> toResponse() throws IOException {
        GitHubPageContentsIterator iterator = (GitHubPageContentsIterator)this.iterator();
        T[] items = this.toArray(iterator);
        GitHubResponse lastResponse = iterator.lastResponse();
        return new GitHubResponse<T[]>(lastResponse, items);
    }

    private class GitHubPageContentsIterator
    extends PagedIterator<T> {
        public GitHubPageContentsIterator(GitHubPageIterator<T[]> iterator, Consumer<T> itemInitializer) {
            super(iterator, itemInitializer);
        }

        private GitHubResponse<T[]> lastResponse() {
            return ((GitHubPageIterator)this.base).finalResponse();
        }
    }
}

