/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.org.kohsuke.github.internal;

import me.caseload.knockbacksync.shaded.org.kohsuke.github.HttpConnector;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.connector.GitHubConnector;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.extras.HttpClientGitHubConnector;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.extras.okhttp3.OkHttpConnector;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.extras.okhttp3.OkHttpGitHubConnector;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.internal.GitHubConnectorHttpConnectorAdapter;
import okhttp3.OkHttpClient;

public final class DefaultGitHubConnector {
    private DefaultGitHubConnector() {
    }

    public static GitHubConnector create() {
        String defaultConnectorProperty = System.getProperty("test.github.connector", "default");
        return DefaultGitHubConnector.create(defaultConnectorProperty);
    }

    static GitHubConnector create(String defaultConnectorProperty) {
        if (defaultConnectorProperty.equalsIgnoreCase("okhttp")) {
            return new OkHttpGitHubConnector(new OkHttpClient.Builder().build());
        }
        if (defaultConnectorProperty.equalsIgnoreCase("okhttpconnector")) {
            return new GitHubConnectorHttpConnectorAdapter(new OkHttpConnector(new OkHttpClient.Builder().build()));
        }
        if (defaultConnectorProperty.equalsIgnoreCase("urlconnection")) {
            return new GitHubConnectorHttpConnectorAdapter(HttpConnector.DEFAULT);
        }
        if (defaultConnectorProperty.equalsIgnoreCase("httpclient")) {
            return new HttpClientGitHubConnector();
        }
        if (defaultConnectorProperty.equalsIgnoreCase("default")) {
            try {
                return new HttpClientGitHubConnector();
            }
            catch (LinkageError | UnsupportedOperationException e) {
                return new GitHubConnectorHttpConnectorAdapter(HttpConnector.DEFAULT);
            }
        }
        throw new IllegalStateException("Property 'test.github.connector' must reference a valid built-in connector - okhttp, okhttpconnector, urlconnection, or default.");
    }
}

