/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.wrapper.play.server;

import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.attribute.Attribute;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.attribute.Attributes;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.resources.ResourceLocation;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;

public class WrapperPlayServerUpdateAttributes
extends PacketWrapper<WrapperPlayServerUpdateAttributes> {
    private static final List<Map.Entry<String, Attribute>> PRE_1_16_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList(new AbstractMap.SimpleEntry<String, Attribute>("generic.maxHealth", Attributes.MAX_HEALTH), new AbstractMap.SimpleEntry<String, Attribute>("Max Health", Attributes.MAX_HEALTH), new AbstractMap.SimpleEntry<String, Attribute>("zombie.spawnReinforcements", Attributes.SPAWN_REINFORCEMENTS), new AbstractMap.SimpleEntry<String, Attribute>("Spawn Reinforcements Chance", Attributes.SPAWN_REINFORCEMENTS), new AbstractMap.SimpleEntry<String, Attribute>("horse.jumpStrength", Attributes.HORSE_JUMP_STRENGTH), new AbstractMap.SimpleEntry<String, Attribute>("Jump Strength", Attributes.HORSE_JUMP_STRENGTH), new AbstractMap.SimpleEntry<String, Attribute>("generic.followRange", Attributes.FOLLOW_RANGE), new AbstractMap.SimpleEntry<String, Attribute>("Follow Range", Attributes.FOLLOW_RANGE), new AbstractMap.SimpleEntry<String, Attribute>("generic.knockbackResistance", Attributes.KNOCKBACK_RESISTANCE), new AbstractMap.SimpleEntry<String, Attribute>("Knockback Resistance", Attributes.KNOCKBACK_RESISTANCE), new AbstractMap.SimpleEntry<String, Attribute>("generic.movementSpeed", Attributes.MOVEMENT_SPEED), new AbstractMap.SimpleEntry<String, Attribute>("Movement Speed", Attributes.MOVEMENT_SPEED), new AbstractMap.SimpleEntry<String, Attribute>("generic.flyingSpeed", Attributes.FLYING_SPEED), new AbstractMap.SimpleEntry<String, Attribute>("Flying Speed", Attributes.FLYING_SPEED), new AbstractMap.SimpleEntry<String, Attribute>("generic.attackDamage", Attributes.ATTACK_DAMAGE), new AbstractMap.SimpleEntry<String, Attribute>("generic.attackKnockback", Attributes.ATTACK_KNOCKBACK), new AbstractMap.SimpleEntry<String, Attribute>("generic.attackSpeed", Attributes.ATTACK_SPEED), new AbstractMap.SimpleEntry<String, Attribute>("generic.armorToughness", Attributes.ARMOR_TOUGHNESS), new AbstractMap.SimpleEntry<String, Attribute>("generic.armor", Attributes.ARMOR), new AbstractMap.SimpleEntry<String, Attribute>("generic.luck", Attributes.LUCK)));
    private static final Map<String, Attribute> PRE_1_16_ATTRIBUTES_MAP = PRE_1_16_ATTRIBUTES.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    private static final Map<Attribute, String> PRE_1_16_ATTRIBUTES_RMAP = PRE_1_16_ATTRIBUTES.stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (s1, s2) -> s1));
    private int entityID;
    private List<Property> properties;

    public WrapperPlayServerUpdateAttributes(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerUpdateAttributes(int entityID, List<Property> properties) {
        super(PacketType.Play.Server.UPDATE_ATTRIBUTES);
        this.entityID = entityID;
        this.properties = properties;
    }

    @Override
    public void read() {
        this.entityID = this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10) ? this.readInt() : this.readVarInt();
        this.readProperties();
    }

    protected void readProperties() {
        int propertyCount = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17) ? this.readVarInt() : this.readInt();
        this.properties = new ArrayList<Property>(propertyCount);
        for (int i = 0; i < propertyCount; ++i) {
            Attribute attribute;
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
                attribute = this.readMappedEntity(Attributes::getById);
            } else if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16)) {
                attribute = Attributes.getByName(this.readIdentifier().toString());
            } else {
                String attributeName = this.readString(64);
                attribute = PRE_1_16_ATTRIBUTES_MAP.get(attributeName);
                if (attribute == null) {
                    attribute = Attributes.getByName(attributeName);
                }
                if (attribute == null) {
                    throw new IllegalStateException("Can't find attribute for name " + attributeName + " (version: " + this.serverVersion.name() + ")");
                }
            }
            double value = this.readDouble();
            int modifiersLength = this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10) ? this.readShort() : this.readVarInt();
            ArrayList<PropertyModifier> modifiers = new ArrayList<PropertyModifier>(modifiersLength);
            for (int j = 0; j < modifiersLength; ++j) {
                UUID uuid;
                ResourceLocation name;
                if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21)) {
                    name = this.readIdentifier();
                    uuid = PropertyModifier.generateSemiUniqueId(name);
                } else {
                    uuid = this.readUUID();
                    name = new ResourceLocation(uuid.toString());
                }
                double amount = this.readDouble();
                byte operationIndex = this.readByte();
                PropertyModifier.Operation operation = PropertyModifier.Operation.VALUES[operationIndex];
                modifiers.add(new PropertyModifier(name, uuid, amount, operation));
            }
            this.properties.add(new Property(attribute, value, modifiers));
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
            this.writeInt(this.entityID);
        } else {
            this.writeVarInt(this.entityID);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
            this.writeVarInt(this.properties.size());
        } else {
            this.writeInt(this.properties.size());
        }
        for (Property property : this.properties) {
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
                this.writeVarInt(property.getAttribute().getId(this.serverVersion.toClientVersion()));
            } else if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16)) {
                this.writeIdentifier(property.getAttribute().getName(this.serverVersion.toClientVersion()));
            } else {
                String str = PRE_1_16_ATTRIBUTES_RMAP.get(property.getAttribute());
                this.writeString(str != null ? str : property.getAttribute().getName().toString());
            }
            this.writeDouble(property.value);
            if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
                this.writeShort(property.modifiers.size());
            } else {
                this.writeVarInt(property.modifiers.size());
            }
            for (PropertyModifier modifier : property.modifiers) {
                if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21)) {
                    this.writeIdentifier(modifier.name);
                } else {
                    this.writeUUID(modifier.uuid);
                }
                this.writeDouble(modifier.amount);
                this.writeByte(modifier.operation.ordinal());
            }
        }
    }

    @Override
    public void copy(WrapperPlayServerUpdateAttributes wrapper) {
        this.entityID = wrapper.entityID;
        this.properties = wrapper.properties;
    }

    public int getEntityId() {
        return this.entityID;
    }

    public void setEntityId(int entityID) {
        this.entityID = entityID;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public static class PropertyModifier {
        private ResourceLocation name;
        private UUID uuid;
        private double amount;
        private Operation operation;

        public PropertyModifier(UUID uuid, double amount, Operation operation) {
            this(new ResourceLocation(uuid.toString()), uuid, amount, operation);
        }

        public PropertyModifier(ResourceLocation name, double amount, Operation operation) {
            this(name, PropertyModifier.generateSemiUniqueId(name), amount, operation);
        }

        public PropertyModifier(ResourceLocation name, UUID uuid, double amount, Operation operation) {
            this.name = name;
            this.uuid = uuid;
            this.amount = amount;
            this.operation = operation;
        }

        @ApiStatus.Internal
        public static UUID generateSemiUniqueId(ResourceLocation name) {
            String extendedName = "packetevents_" + name.toString();
            return UUID.nameUUIDFromBytes(extendedName.getBytes(StandardCharsets.UTF_8));
        }

        public ResourceLocation getName() {
            return this.name;
        }

        public void setName(ResourceLocation name) {
            this.name = name;
            this.uuid = PropertyModifier.generateSemiUniqueId(name);
        }

        @ApiStatus.Obsolete
        public UUID getUUID() {
            return this.uuid;
        }

        @ApiStatus.Obsolete
        public void setUUID(UUID uuid) {
            this.name = new ResourceLocation(uuid.toString());
            this.uuid = uuid;
        }

        public void setNameAndUUID(ResourceLocation name, UUID uuid) {
            this.name = name;
            this.uuid = uuid;
        }

        public double getAmount() {
            return this.amount;
        }

        public void setAmount(double amount) {
            this.amount = amount;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public void setOperation(Operation operation) {
            this.operation = operation;
        }

        public static enum Operation {
            ADDITION,
            MULTIPLY_BASE,
            MULTIPLY_TOTAL;

            public static final Operation[] VALUES;

            static {
                VALUES = Operation.values();
            }
        }
    }

    public static class Property {
        private Attribute attribute;
        private double value;
        private List<PropertyModifier> modifiers;
        private transient Double calculatedValue = null;

        @Deprecated
        public Property(String key, double value, List<PropertyModifier> modifiers) {
            this(Attributes.getByName(key), value, modifiers);
        }

        public Property(Attribute attribute, double value, List<PropertyModifier> modifiers) {
            this.attribute = attribute;
            this.value = value;
            this.modifiers = modifiers;
        }

        public double calcValue() {
            if (this.calculatedValue == null) {
                this.calculatedValue = this.calcValue0();
            }
            return this.calculatedValue;
        }

        public double calcValue0() {
            double base = this.getValue();
            for (PropertyModifier modifier : this.modifiers) {
                if (modifier.getOperation() != PropertyModifier.Operation.ADDITION) continue;
                base += modifier.getAmount();
            }
            double value = base;
            for (PropertyModifier modifier : this.modifiers) {
                if (modifier.getOperation() != PropertyModifier.Operation.MULTIPLY_BASE) continue;
                value += base * modifier.getAmount();
            }
            for (PropertyModifier modifier : this.modifiers) {
                if (modifier.getOperation() != PropertyModifier.Operation.MULTIPLY_TOTAL) continue;
                value *= 1.0 + modifier.getAmount();
            }
            return this.attribute.sanitizeValue(value);
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public void setAttribute(Attribute attribute) {
            this.attribute = attribute;
        }

        @Deprecated
        public String getKey() {
            return this.getAttribute().getName().toString();
        }

        @Deprecated
        public void setKey(String key) {
            this.setAttribute(Attributes.getByName(key));
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
            this.setDirty();
        }

        public void addModifier(PropertyModifier modifier) {
            this.modifiers.add(modifier);
            this.setDirty();
        }

        public boolean removeModifier(ResourceLocation modifierId) {
            return this.removeModifierIf(modifier -> modifierId.equals(modifier.getName()));
        }

        @ApiStatus.Obsolete
        public boolean removeModifier(UUID modifierId) {
            return this.removeModifierIf(modifier -> modifierId.equals(modifier.getUUID()));
        }

        @ApiStatus.Obsolete
        public boolean removeModifier(ResourceLocation modifierId, UUID modifierUId) {
            return this.removeModifierIf(modifier -> modifierUId.equals(modifier.getUUID()) || modifierId.equals(modifier.getName()));
        }

        public boolean removeModifierIf(Predicate<PropertyModifier> predicate) {
            boolean ret = this.modifiers.removeIf(predicate);
            if (ret) {
                this.setDirty();
            }
            return ret;
        }

        public List<PropertyModifier> getModifiers() {
            return this.modifiers;
        }

        public void setModifiers(List<PropertyModifier> modifiers) {
            this.modifiers = modifiers;
            this.setDirty();
        }

        public void setDirty() {
            this.calculatedValue = null;
        }
    }
}

