/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.io.github.retrooper.packetevents.manager;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.UUID;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.PacketEvents;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.PacketEventsAPI;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.manager.InternalPacketListener;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.ConnectionState;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.player.User;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.util.LogManager;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.wrapper.handshaking.client.WrapperHandshakingClientHandshake;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.wrapper.login.server.WrapperLoginServerLoginSuccess;
import me.caseload.knockbacksync.shaded.io.github.retrooper.packetevents.injector.SpigotChannelInjector;
import me.caseload.knockbacksync.shaded.io.github.retrooper.packetevents.manager.player.PlayerManagerImpl;
import me.caseload.knockbacksync.shaded.io.github.retrooper.packetevents.util.protocolsupport.ProtocolSupportUtil;
import me.caseload.knockbacksync.shaded.io.github.retrooper.packetevents.util.viaversion.ViaVersionUtil;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class InternalBukkitPacketListener
extends InternalPacketListener {
    @Override
    public void onPacketSend(PacketSendEvent event) {
        super.onPacketSend(event);
        if (event.getPacketType() == PacketType.Login.Server.LOGIN_SUCCESS) {
            WrapperLoginServerLoginSuccess packet = new WrapperLoginServerLoginSuccess(event);
            this.tryUpdatePlayerReference(event, event.getUser(), packet.getUserProfile().getUUID());
        } else if (event.getPacketType() == PacketType.Play.Server.JOIN_GAME) {
            this.tryUpdatePlayerReference(event, event.getUser(), event.getUser().getUUID());
        }
    }

    private void tryUpdatePlayerReference(PacketSendEvent event, User user, UUID playerId) {
        Player player;
        PacketEventsAPI<?> api = PacketEvents.getAPI();
        Map<UUID, WeakReference<Player>> map = ((PlayerManagerImpl)api.getPlayerManager()).joiningPlayers;
        WeakReference<Player> playerRef = map.remove(playerId);
        Player player2 = player = playerRef != null ? (Player)playerRef.get() : null;
        if (player != null) {
            ((SpigotChannelInjector)api.getInjector()).updatePlayer(user, player);
            if (api.getLogManager().isDebug()) {
                api.getLogManager().debug("Updated player reference on packet handling for " + player.getUniqueId());
            }
            event.setPlayer(player);
        }
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Handshaking.Client.HANDSHAKE) {
            String feature;
            User user = event.getUser();
            WrapperHandshakingClientHandshake packet = new WrapperHandshakingClientHandshake(event);
            ClientVersion clientVersion = packet.getClientVersion();
            ConnectionState state = packet.getNextConnectionState();
            if (!this.isPreVia()) {
                if (ViaVersionUtil.isAvailable()) {
                    clientVersion = ClientVersion.getById(ViaVersionUtil.getProtocolVersion(user));
                    feature = "ViaVersion";
                } else if (ProtocolSupportUtil.isAvailable()) {
                    clientVersion = ClientVersion.getById(ProtocolSupportUtil.getProtocolVersion(user.getAddress()));
                    feature = "ProtocolSupport";
                } else {
                    feature = null;
                }
            } else {
                feature = "Client Version Handshake";
            }
            LogManager logger = PacketEvents.getAPI().getLogManager();
            if (logger.isDebug()) {
                logger.debug("Processed handshake for " + event.getAddress() + ": " + state.name() + " / " + packet.getClientVersion().getReleaseName() + (feature != null ? " (using " + feature + ")" : ""));
            }
            user.setClientVersion(clientVersion);
            user.setConnectionState(state);
        } else {
            super.onPacketReceive(event);
        }
    }
}

