/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.org.kohsuke.github;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import java.util.logging.Logger;
import me.caseload.knockbacksync.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHError;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHException;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHIOException;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHNotExternallyManagedEnterpriseException;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHOrganization;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHTeamCannotBeExternallyManagedException;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHubClient;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.HttpException;

class EnterpriseManagedSupport {
    static final String COULD_NOT_RETRIEVE_ORGANIZATION_EXTERNAL_GROUPS = "Could not retrieve organization external groups";
    static final String NOT_PART_OF_EXTERNALLY_MANAGED_ENTERPRISE_ERROR = "This organization is not part of externally managed enterprise.";
    static final String TEAM_CANNOT_BE_EXTERNALLY_MANAGED_ERROR = "This team cannot be externally managed since it has explicit members.";
    private static final Logger LOGGER = Logger.getLogger(EnterpriseManagedSupport.class.getName());
    private final GHOrganization organization;

    private EnterpriseManagedSupport(GHOrganization organization) {
        this.organization = organization;
    }

    Optional<GHIOException> filterException(HttpException he, String scenario) {
        if (he.getResponseCode() == 400) {
            String responseMessage = he.getMessage();
            try {
                GHError error = (GHError)GitHubClient.getMappingObjectReader(this.organization.root()).forType(GHError.class).readValue(responseMessage);
                if (NOT_PART_OF_EXTERNALLY_MANAGED_ENTERPRISE_ERROR.equals(error.getMessage())) {
                    return Optional.of(new GHNotExternallyManagedEnterpriseException(scenario, error, he));
                }
                if (TEAM_CANNOT_BE_EXTERNALLY_MANAGED_ERROR.equals(error.getMessage())) {
                    return Optional.of(new GHTeamCannotBeExternallyManagedException(scenario, error, he));
                }
            }
            catch (JsonProcessingException e) {
                LOGGER.warning(() -> EnterpriseManagedSupport.logUnexpectedFailure(e, responseMessage));
            }
        }
        return Optional.empty();
    }

    Optional<GHException> filterException(GHException e) {
        if (e.getCause() instanceof HttpException) {
            HttpException he = (HttpException)e.getCause();
            return this.filterException(he, COULD_NOT_RETRIEVE_ORGANIZATION_EXTERNAL_GROUPS).map(translated -> new GHException(COULD_NOT_RETRIEVE_ORGANIZATION_EXTERNAL_GROUPS, (Throwable)translated));
        }
        return Optional.empty();
    }

    static EnterpriseManagedSupport forOrganization(GHOrganization org) {
        return new EnterpriseManagedSupport(org);
    }

    private static String logUnexpectedFailure(JsonProcessingException exception, String payload) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        return String.format("Could not parse GitHub error response: '%s'. Full stacktrace follows:%n%s", payload, sw);
    }
}

