/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.org.kohsuke.github;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHBranch;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHDirection;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHPullRequest;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHRepository;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHSearchBuilder;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GHUser;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHub;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.PagedSearchIterable;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.SearchResult;

public class GHPullRequestSearchBuilder
extends GHSearchBuilder<GHPullRequest> {
    GHPullRequestSearchBuilder(GitHub root) {
        super(root, PullRequestSearchResult.class);
    }

    public GHPullRequestSearchBuilder repo(GHRepository repository) {
        this.q("repo", repository.getFullName());
        return this;
    }

    public GHPullRequestSearchBuilder author(GHUser user) {
        this.q("author", user.getLogin());
        return this;
    }

    public GHPullRequestSearchBuilder createdByMe() {
        this.q("author:@me");
        return this;
    }

    public GHPullRequestSearchBuilder assigned(GHUser u) {
        this.q("assignee", u.getLogin());
        return this;
    }

    public GHPullRequestSearchBuilder mentions(GHUser u) {
        this.q("mentions", u.getLogin());
        return this;
    }

    public GHPullRequestSearchBuilder isOpen() {
        return this.q("is:open");
    }

    public GHPullRequestSearchBuilder isClosed() {
        return this.q("is:closed");
    }

    public GHPullRequestSearchBuilder isMerged() {
        return this.q("is:merged");
    }

    public GHPullRequestSearchBuilder isDraft() {
        return this.q("draft:true");
    }

    public GHPullRequestSearchBuilder head(GHBranch branch) {
        this.q("head", branch.getName());
        return this;
    }

    public GHPullRequestSearchBuilder base(GHBranch branch) {
        this.q("base", branch.getName());
        return this;
    }

    public GHPullRequestSearchBuilder commit(String sha) {
        this.q("SHA", sha);
        return this;
    }

    public GHPullRequestSearchBuilder created(LocalDate created) {
        this.q("created", created.format(DateTimeFormatter.ISO_DATE));
        return this;
    }

    public GHPullRequestSearchBuilder createdBefore(LocalDate created, boolean inclusive) {
        String comparisonSign = inclusive ? "<=" : "<";
        this.q("created:" + comparisonSign + created.format(DateTimeFormatter.ISO_DATE));
        return this;
    }

    public GHPullRequestSearchBuilder createdAfter(LocalDate created, boolean inclusive) {
        String comparisonSign = inclusive ? ">=" : ">";
        this.q("created:" + comparisonSign + created.format(DateTimeFormatter.ISO_DATE));
        return this;
    }

    public GHPullRequestSearchBuilder created(LocalDate from, LocalDate to) {
        String createdRange = from.format(DateTimeFormatter.ISO_DATE) + ".." + to.format(DateTimeFormatter.ISO_DATE);
        this.q("created", createdRange);
        return this;
    }

    public GHPullRequestSearchBuilder merged(LocalDate merged) {
        this.q("merged", merged.format(DateTimeFormatter.ISO_DATE));
        return this;
    }

    public GHPullRequestSearchBuilder mergedBefore(LocalDate merged, boolean inclusive) {
        String comparisonSign = inclusive ? "<=" : "<";
        this.q("merged:" + comparisonSign + merged.format(DateTimeFormatter.ISO_DATE));
        return this;
    }

    public GHPullRequestSearchBuilder mergedAfter(LocalDate merged, boolean inclusive) {
        String comparisonSign = inclusive ? ">=" : ">";
        this.q("merged:" + comparisonSign + merged.format(DateTimeFormatter.ISO_DATE));
        return this;
    }

    public GHPullRequestSearchBuilder merged(LocalDate from, LocalDate to) {
        String mergedRange = from.format(DateTimeFormatter.ISO_DATE) + ".." + to.format(DateTimeFormatter.ISO_DATE);
        this.q("merged", mergedRange);
        return this;
    }

    public GHPullRequestSearchBuilder closed(LocalDate closed) {
        this.q("closed", closed.format(DateTimeFormatter.ISO_DATE));
        return this;
    }

    public GHPullRequestSearchBuilder closedBefore(LocalDate closed, boolean inclusive) {
        String comparisonSign = inclusive ? "<=" : "<";
        this.q("closed:" + comparisonSign + closed.format(DateTimeFormatter.ISO_DATE));
        return this;
    }

    public GHPullRequestSearchBuilder closedAfter(LocalDate closed, boolean inclusive) {
        String comparisonSign = inclusive ? ">=" : ">";
        this.q("closed:" + comparisonSign + closed.format(DateTimeFormatter.ISO_DATE));
        return this;
    }

    public GHPullRequestSearchBuilder closed(LocalDate from, LocalDate to) {
        String closedRange = from.format(DateTimeFormatter.ISO_DATE) + ".." + to.format(DateTimeFormatter.ISO_DATE);
        this.q("closed", closedRange);
        return this;
    }

    public GHPullRequestSearchBuilder updated(LocalDate updated) {
        this.q("updated", updated.format(DateTimeFormatter.ISO_DATE));
        return this;
    }

    public GHPullRequestSearchBuilder updatedBefore(LocalDate updated, boolean inclusive) {
        String comparisonSign = inclusive ? "<=" : "<";
        this.q("updated:" + comparisonSign + updated.format(DateTimeFormatter.ISO_DATE));
        return this;
    }

    public GHPullRequestSearchBuilder updatedAfter(LocalDate updated, boolean inclusive) {
        String comparisonSign = inclusive ? ">=" : ">";
        this.q("updated:" + comparisonSign + updated.format(DateTimeFormatter.ISO_DATE));
        return this;
    }

    public GHPullRequestSearchBuilder updated(LocalDate from, LocalDate to) {
        String updatedRange = from.format(DateTimeFormatter.ISO_DATE) + ".." + to.format(DateTimeFormatter.ISO_DATE);
        this.q("updated", updatedRange);
        return this;
    }

    public GHPullRequestSearchBuilder label(String label) {
        this.q("label", label);
        return this;
    }

    public GHPullRequestSearchBuilder inLabels(Iterable<String> labels) {
        this.q("label", String.join((CharSequence)",", labels));
        return this;
    }

    public GHPullRequestSearchBuilder titleLike(String title) {
        this.q(title + " in:title");
        return this;
    }

    public GHPullRequestSearchBuilder order(GHDirection direction) {
        this.req.with("order", direction);
        return this;
    }

    public GHPullRequestSearchBuilder sort(Sort sort) {
        this.req.with("sort", sort);
        return this;
    }

    public GHPullRequestSearchBuilder q(String term) {
        super.q(term);
        return this;
    }

    @Override
    public PagedSearchIterable<GHPullRequest> list() {
        this.q("is:pr");
        return super.list();
    }

    @Override
    protected String getApiUrl() {
        return "/search/issues";
    }

    private static class PullRequestSearchResult
    extends SearchResult<GHPullRequest> {
        private GHPullRequest[] items;

        private PullRequestSearchResult() {
        }

        GHPullRequest[] getItems(GitHub root) {
            return this.items;
        }
    }

    public static enum Sort {
        COMMENTS,
        CREATED,
        UPDATED,
        RELEVANCE;

    }
}

