/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.org.incendo.cloud;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.CommandManager;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.context.CommandContext;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.context.CommandContextFactory;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.context.CommandInput;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.exception.handling.ExceptionController;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.execution.CommandExecutor;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.execution.CommandResult;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.execution.ExecutionCoordinator;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.services.State;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.util.CompletableFutures;
import org.checkerframework.checker.nullness.qual.NonNull;

final class StandardCommandExecutor<C>
implements CommandExecutor<C> {
    private final CommandManager<C> commandManager;
    private final ExecutionCoordinator<C> executionCoordinator;
    private final CommandContextFactory<C> commandContextFactory;

    StandardCommandExecutor(@NonNull CommandManager<C> commandManager, @NonNull ExecutionCoordinator<C> executionCoordinator, @NonNull CommandContextFactory<C> commandContextFactory) {
        this.commandManager = commandManager;
        this.executionCoordinator = executionCoordinator;
        this.commandContextFactory = commandContextFactory;
    }

    @Override
    public @NonNull CompletableFuture<CommandResult<C>> executeCommand(@NonNull C commandSender, @NonNull String input, @NonNull Consumer<CommandContext<C>> contextConsumer) {
        CommandContext<C> context = this.commandContextFactory.create(false, commandSender);
        contextConsumer.accept(context);
        CommandInput commandInput = CommandInput.of(input);
        return this.executeCommand(context, commandInput).whenComplete((result, throwable) -> {
            if (throwable == null) {
                return;
            }
            try {
                this.commandManager.exceptionController().handleException(context, ExceptionController.unwrapCompletionException(throwable));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable e) {
                throw new CompletionException(e);
            }
        });
    }

    private @NonNull CompletableFuture<CommandResult<C>> executeCommand(@NonNull CommandContext<C> context, @NonNull CommandInput commandInput) {
        context.store("__raw_input__", commandInput.copy());
        try {
            if (this.commandManager.preprocessContext(context, commandInput) == State.ACCEPTED) {
                return this.executionCoordinator().coordinateExecution(this.commandManager.commandTree(), context, commandInput);
            }
        }
        catch (Exception e) {
            return CompletableFutures.failedFuture(e);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public @NonNull ExecutionCoordinator<C> executionCoordinator() {
        return this.executionCoordinator;
    }
}

