/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.org.kohsuke.github.extras.okhttp3;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import me.caseload.knockbacksync.shaded.org.apache.commons.io.IOUtils;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.connector.GitHubConnector;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.connector.GitHubConnectorRequest;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.connector.GitHubConnectorResponse;
import okhttp3.CacheControl;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpGitHubConnector
implements GitHubConnector {
    private static final String HEADER_NAME = "Cache-Control";
    private final String maxAgeHeaderValue;
    private final OkHttpClient client;

    public OkHttpGitHubConnector(OkHttpClient client) {
        this(client, 0);
    }

    public OkHttpGitHubConnector(OkHttpClient client, int cacheMaxAge) {
        OkHttpClient.Builder builder = client.newBuilder();
        builder.connectionSpecs(this.TlsConnectionSpecs());
        this.client = builder.build();
        this.maxAgeHeaderValue = cacheMaxAge >= 0 && this.client != null && this.client.cache() != null ? new CacheControl.Builder().maxAge(cacheMaxAge, TimeUnit.SECONDS).build().toString() : null;
    }

    @Override
    public GitHubConnectorResponse send(GitHubConnectorRequest request) throws IOException {
        Request.Builder builder = new Request.Builder().url(request.url());
        if (this.maxAgeHeaderValue != null && request.header(HEADER_NAME) == null) {
            builder.header(HEADER_NAME, this.maxAgeHeaderValue);
        }
        for (Map.Entry<String, List<String>> e : request.allHeaders().entrySet()) {
            List<String> v = e.getValue();
            if (v == null) continue;
            builder.addHeader(e.getKey(), String.join((CharSequence)", ", v));
        }
        RequestBody body = null;
        if (request.hasBody()) {
            body = RequestBody.create((byte[])IOUtils.toByteArray(request.body()));
        }
        builder.method(request.method(), body);
        Request okhttpRequest = builder.build();
        Response okhttpResponse = this.client.newCall(okhttpRequest).execute();
        return new OkHttpGitHubConnectorResponse(request, okhttpResponse);
    }

    private List<ConnectionSpec> TlsConnectionSpecs() {
        return Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.CLEARTEXT);
    }

    private static class OkHttpGitHubConnectorResponse
    extends GitHubConnectorResponse.ByteArrayResponse {
        @Nonnull
        private final Response response;

        OkHttpGitHubConnectorResponse(@Nonnull GitHubConnectorRequest request, @Nonnull Response response) {
            super(request, response.code(), response.headers().toMultimap());
            this.response = response;
        }

        @Override
        @CheckForNull
        protected InputStream rawBodyStream() throws IOException {
            ResponseBody body = this.response.body();
            if (body != null) {
                return body.byteStream();
            }
            return null;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.response.close();
        }
    }
}

