/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import lombok.Generated;
import me.caseload.knockbacksync.Platform;
import me.caseload.knockbacksync.command.MainCommand;
import me.caseload.knockbacksync.command.generic.AbstractPlayerSelectorParser;
import me.caseload.knockbacksync.command.generic.BuilderCommand;
import me.caseload.knockbacksync.command.subcommand.PingCommand;
import me.caseload.knockbacksync.command.subcommand.ReloadCommand;
import me.caseload.knockbacksync.command.subcommand.StatusCommand;
import me.caseload.knockbacksync.command.subcommand.ToggleCommand;
import me.caseload.knockbacksync.command.subcommand.ToggleOffGroundSubcommand;
import me.caseload.knockbacksync.event.Event;
import me.caseload.knockbacksync.event.EventBus;
import me.caseload.knockbacksync.event.OptimizedEventBus;
import me.caseload.knockbacksync.listener.packetevents.AttributeChangeListener;
import me.caseload.knockbacksync.listener.packetevents.ClientBrandListener;
import me.caseload.knockbacksync.listener.packetevents.PacketPlayerJoinQuit;
import me.caseload.knockbacksync.listener.packetevents.PingReceiveListener;
import me.caseload.knockbacksync.listener.packetevents.PingSendListener;
import me.caseload.knockbacksync.manager.ConfigManager;
import me.caseload.knockbacksync.permission.PermissionChecker;
import me.caseload.knockbacksync.scheduler.SchedulerAdapter;
import me.caseload.knockbacksync.sender.Sender;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.PacketEvents;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.CommandManager;
import me.caseload.knockbacksync.shaded.org.kohsuke.github.GitHub;
import me.caseload.knockbacksync.stats.custom.PluginJarHashProvider;
import me.caseload.knockbacksync.stats.custom.StatsManager;
import me.caseload.knockbacksync.world.PlatformServer;

public abstract class Base {
    public static Logger LOGGER;
    public static Base INSTANCE;
    private final Platform platform;
    protected StatsManager statsManager;
    protected PlatformServer platformServer;
    protected PluginJarHashProvider pluginJarHashProvider;
    protected SchedulerAdapter scheduler;
    protected ConfigManager configManager;
    protected CommandManager<Sender> commandManager;
    protected final EventBus eventBus = new OptimizedEventBus();
    protected AbstractPlayerSelectorParser<Sender> playerSelectorParser;

    protected Base() {
        this.platform = this.detectPlatform();
        INSTANCE = this;
    }

    private Platform detectPlatform() {
        Map<String, Platform> platforms = Collections.unmodifiableMap(new HashMap<String, Platform>(){
            {
                this.put("io.papermc.paper.threadedregions.RegionizedServer", Platform.FOLIA);
                this.put("org.bukkit.Bukkit", Platform.BUKKIT);
                this.put("net.fabricmc.loader.api.FabricLoader", Platform.FABRIC);
            }
        });
        return platforms.entrySet().stream().filter(entry -> this.isClassPresent((String)entry.getKey())).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new IllegalStateException("Unknown platform!"));
    }

    private boolean isClassPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    public abstract Logger getLogger();

    public abstract File getDataFolder();

    public abstract InputStream getResource(String var1);

    public abstract void load();

    public void enable() {
        LOGGER = this.getLogger();
        this.saveDefaultConfig();
        this.initializePacketEvents();
        this.registerCommonListeners();
        this.registerPlatformListeners();
        this.registerCommands();
        this.initializeScheduler();
        this.configManager.loadConfig(false);
        this.statsManager.init();
        this.checkForUpdates();
    }

    public abstract void initializeScheduler();

    public void initializePacketEvents() {
        PacketEvents.getAPI().getSettings().checkForUpdates(false).debug(false);
        PacketEvents.getAPI().init();
    }

    protected void registerCommonListeners() {
        PacketEvents.getAPI().getEventManager().registerListeners(new AttributeChangeListener(), new PingSendListener(), new PingReceiveListener(), new PacketPlayerJoinQuit(), new ClientBrandListener());
        Event.setEventBus(this.eventBus);
    }

    protected abstract void registerPlatformListeners();

    protected void registerCommands() {
        List<BuilderCommand> list = Arrays.asList(new MainCommand(), new ReloadCommand(), new PingCommand(), new StatusCommand(), new ToggleOffGroundSubcommand(), new ToggleCommand());
        list.forEach(command -> command.register(this.commandManager));
    }

    protected abstract String getVersion();

    protected void checkForUpdates() {
        this.getLogger().info("Checking for updates...");
        this.scheduler.runTaskAsynchronously(() -> {
            try {
                GitHub github = GitHub.connectAnonymously();
                String latestVersion = github.getRepository("CASELOAD7000/knockback-sync").getLatestRelease().getTagName();
                String currentVersion = this.getVersion();
                int comparisonResult = this.compareVersions(currentVersion, latestVersion);
                if (comparisonResult < 0) {
                    LOGGER.warning("You are running an older version. A new update is available for download at: https://github.com/CASELOAD7000/knockback-sync/releases/latest");
                    this.configManager.setUpdateAvailable(true);
                } else if (comparisonResult > 0) {
                    if (currentVersion.contains("-dev")) {
                        LOGGER.info("You are running a development build newer than the latest release.");
                    } else {
                        LOGGER.info("You are running a version newer than the latest release.");
                    }
                } else {
                    LOGGER.info("You are running the latest release.");
                }
                if (this.configManager.isUpdateAvailable() && this.configManager.isAutoUpdate()) {
                    LOGGER.info("Updating...");
                    byte[] bytes = this.downloadLatestRelease(github);
                    this.updatePlugin(bytes);
                    if (this.hasRestartScript()) {
                        this.scheduler.runTask(this::restartServer);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.severe("Failed to check for updates: " + e.getMessage());
            }
        });
    }

    private void updatePlugin(byte[] pluginBytes) throws URISyntaxException {
        File file = new File(this.getJarURL().toURI());
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            outputStream.write(pluginBytes);
            LOGGER.info("Successfully updated the plugin!");
        }
        catch (Exception e) {
            LOGGER.severe("Failed to update: " + e.getMessage());
        }
    }

    private byte[] downloadLatestRelease(GitHub github) {
        try {
            return github.getRepository("CASELOAD7000/knockback-sync").getLatestRelease().getAssets().stream().filter(asset -> asset.getName().endsWith(".jar") && asset.getName().contains(this.platform.equals((Object)Platform.FABRIC) ? "fabric" : "bukkit")).findFirst().map(asset -> {
                byte[] byArray;
                block8: {
                    InputStream inputStream = new URL(asset.getBrowserDownloadUrl()).openStream();
                    try {
                        inputStream.reset();
                        byte[] bytes = new byte[inputStream.available()];
                        DataInputStream dataInputStream = new DataInputStream(inputStream);
                        dataInputStream.readFully(bytes);
                        byArray = bytes;
                        if (inputStream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.severe("Failed to download latest release: " + e.getMessage());
                            return null;
                        }
                    }
                    inputStream.close();
                }
                return byArray;
            }).orElse(null);
        }
        catch (Exception e) {
            LOGGER.severe("Failed to locate latest release: " + e.getMessage());
            return null;
        }
    }

    private int compareVersions(String version1, String version2) {
        String[] v1Parts = version1.split("[-.]");
        String[] v2Parts = version2.split("[-.]");
        int length = Math.min(v1Parts.length, v2Parts.length);
        for (int i = 0; i < length; ++i) {
            int comparison = this.compareVersionPart(v1Parts[i], v2Parts[i]);
            if (comparison == 0) continue;
            return comparison;
        }
        if (v1Parts.length != v2Parts.length) {
            return this.compareSpecialVersions(v1Parts, v2Parts);
        }
        return 0;
    }

    private int compareVersionPart(String part1, String part2) {
        try {
            int v1 = Integer.parseInt(part1);
            int v2 = Integer.parseInt(part2);
            return Integer.compare(v1, v2);
        }
        catch (NumberFormatException e) {
            return this.compareSpecialPart(part1, part2);
        }
    }

    private int compareSpecialPart(String part1, String part2) {
        if (part1.equals(part2)) {
            return 0;
        }
        if (part1.startsWith("dev")) {
            return part2.startsWith("dev") ? 0 : -1;
        }
        if (part2.startsWith("dev")) {
            return 1;
        }
        if (part1.equals("SNAPSHOT")) {
            return part2.equals("SNAPSHOT") ? 0 : -1;
        }
        if (part2.equals("SNAPSHOT")) {
            return 1;
        }
        return part1.compareTo(part2);
    }

    private int compareSpecialVersions(String[] v1Parts, String[] v2Parts) {
        if (v1Parts.length > v2Parts.length) {
            String specialPart = v1Parts[v2Parts.length];
            if (specialPart.startsWith("dev")) {
                return -1;
            }
            if (specialPart.equals("SNAPSHOT")) {
                return -1;
            }
            return 1;
        }
        String specialPart = v2Parts[v1Parts.length];
        if (specialPart.startsWith("dev")) {
            return 1;
        }
        if (specialPart.equals("SNAPSHOT")) {
            return 1;
        }
        return -1;
    }

    public abstract void saveDefaultConfig();

    public abstract PermissionChecker getPermissionChecker();

    public abstract float getTickRate();

    public abstract URL getJarURL();

    public abstract void restartServer();

    public abstract boolean hasRestartScript();

    @Generated
    public Platform getPlatform() {
        return this.platform;
    }

    @Generated
    public StatsManager getStatsManager() {
        return this.statsManager;
    }

    @Generated
    public PlatformServer getPlatformServer() {
        return this.platformServer;
    }

    @Generated
    public PluginJarHashProvider getPluginJarHashProvider() {
        return this.pluginJarHashProvider;
    }

    @Generated
    public SchedulerAdapter getScheduler() {
        return this.scheduler;
    }

    @Generated
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Generated
    public CommandManager<Sender> getCommandManager() {
        return this.commandManager;
    }

    @Generated
    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Generated
    public AbstractPlayerSelectorParser<Sender> getPlayerSelectorParser() {
        return this.playerSelectorParser;
    }
}

