/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.listener;

import me.caseload.knockbacksync.Base;
import me.caseload.knockbacksync.manager.PlayerDataManager;
import me.caseload.knockbacksync.player.PlatformPlayer;
import me.caseload.knockbacksync.player.PlayerData;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.player.User;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.util.Vector3d;

public abstract class PlayerKnockbackListener {
    public void onPlayerVelocity(PlatformPlayer victim, Vector3d velocity) {
        Vector3d adjustedVelocity;
        if (!Base.INSTANCE.getConfigManager().isToggled()) {
            return;
        }
        User user = victim.getUser();
        if (user == null) {
            return;
        }
        PlayerData victimPlayerData = PlayerDataManager.getPlayerData(user);
        if (victimPlayerData == null) {
            return;
        }
        if (victimPlayerData.getNotNullPing() < 25.0) {
            return;
        }
        double distanceToGround = victimPlayerData.getDistanceToGround();
        if (distanceToGround <= 0.0) {
            return;
        }
        WrappedBlockState blockState = victim.getWorld().getBlockStateAt(victim.getLocation());
        if (victim.isGliding() || blockState.getType() == StateTypes.WATER || blockState.getType() == StateTypes.LAVA || blockState.getType() == StateTypes.COBWEB || blockState.getType() == StateTypes.SCAFFOLDING) {
            return;
        }
        if (victimPlayerData.isOnGroundClientSide(velocity.getY(), distanceToGround)) {
            Integer damageTicks = victimPlayerData.getLastDamageTicks();
            if (damageTicks != null && damageTicks > 8) {
                return;
            }
            adjustedVelocity = velocity.withY(victimPlayerData.getVerticalVelocity());
        } else if (victimPlayerData.isOffGroundSyncEnabled()) {
            adjustedVelocity = velocity.withY(victimPlayerData.getCompensatedOffGroundVelocity());
        } else {
            return;
        }
        victim.setVelocity(adjustedVelocity);
    }
}

