/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.listener.packetevents;

import java.util.List;
import java.util.UUID;
import me.caseload.knockbacksync.Base;
import me.caseload.knockbacksync.manager.PlayerDataManager;
import me.caseload.knockbacksync.player.PlayerData;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.event.PacketListenerAbstract;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.attribute.Attributes;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.player.User;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateAttributes;
import me.caseload.knockbacksync.util.MathUtil;

public class AttributeChangeListener
extends PacketListenerAbstract {
    public static final UUID SPRINTING_MODIFIER_UUID = UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D");
    final double minGravity = -1.0;
    final double maxGravity = 1.0;
    final double defaultGravity = 0.08;
    double currentGravity = 0.08;

    @Override
    public void onPacketSend(PacketSendEvent event) {
        if (!Base.INSTANCE.getConfigManager().isToggled()) {
            return;
        }
        if (event.getPacketType() == PacketType.Play.Server.UPDATE_ATTRIBUTES) {
            WrapperPlayServerUpdateAttributes packet = new WrapperPlayServerUpdateAttributes(event);
            User user = event.getUser();
            if (!PlayerDataManager.containsPlayerData(user)) {
                return;
            }
            for (WrapperPlayServerUpdateAttributes.Property property : packet.getProperties()) {
                if (property.getAttribute().equals(Attributes.GENERIC_GRAVITY)) {
                    this.onPlayerGravityChange(user, this.calculateValueWithModifiers(property));
                    continue;
                }
                if (!property.getAttribute().equals(Attributes.GENERIC_KNOCKBACK_RESISTANCE)) continue;
                this.onPlayerKnockBackChange(user, this.calculateValueWithModifiers(property));
            }
        }
    }

    public double calculateValueWithModifiers(WrapperPlayServerUpdateAttributes.Property property) {
        double baseValue = property.getValue();
        double additionSum = 0.0;
        double multiplyBaseSum = 0.0;
        double multiplyTotalProduct = 1.0;
        List<WrapperPlayServerUpdateAttributes.PropertyModifier> modifiers = property.getModifiers();
        for (WrapperPlayServerUpdateAttributes.PropertyModifier modifier : modifiers) {
            switch (modifier.getOperation()) {
                case ADDITION: {
                    additionSum += modifier.getAmount();
                    break;
                }
                case MULTIPLY_BASE: {
                    multiplyBaseSum += modifier.getAmount();
                    break;
                }
                case MULTIPLY_TOTAL: {
                    multiplyTotalProduct *= 1.0 + modifier.getAmount();
                }
            }
        }
        double newValue = (baseValue + additionSum) * (1.0 + multiplyBaseSum) * multiplyTotalProduct;
        if ((newValue = MathUtil.clamp(newValue, -1.0, 1.0)) < -1.0 || newValue > 1.0) {
            throw new IllegalArgumentException("New value must be between min and max!");
        }
        this.currentGravity = newValue;
        return this.currentGravity;
    }

    public void onPlayerGravityChange(User user, double newGravity) {
        PlayerData playerData = PlayerDataManager.getPlayerData(user);
        if (playerData.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_20_5)) {
            playerData.setGravityAttribute(newGravity);
        } else {
            this.currentGravity = 0.08;
        }
    }

    private void onPlayerKnockBackChange(User user, double newKnockbackResistance) {
        PlayerData playerData = PlayerDataManager.getPlayerData(user);
        playerData.setKnockbackResistanceAttribute(newKnockbackResistance);
    }
}

