/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.player;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import me.caseload.knockbacksync.BukkitBase;
import me.caseload.knockbacksync.Platform;
import me.caseload.knockbacksync.player.PlatformPlayer;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.PacketEvents;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.player.User;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.BoundingBox;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.util.Vector3d;
import me.caseload.knockbacksync.world.FoliaWorld;
import me.caseload.knockbacksync.world.PlatformWorld;
import me.caseload.knockbacksync.world.SpigotWorld;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitPlayer
implements PlatformPlayer {
    public final Player bukkitPlayer;
    public final User user;
    private String clientBrand = "vanilla";
    private static Class<?> craftPlayerClass;
    private static Method getHandleMethod;
    private static Method getAttackStrengthScaleMethod;
    private static final ServerVersion currentVersion;

    public BukkitPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0);
        this.bukkitPlayer = player;
        this.user = PacketEvents.getAPI().getPlayerManager().getUser(this.bukkitPlayer);
    }

    @Override
    public UUID getUUID() {
        return this.bukkitPlayer.getUniqueId();
    }

    @Override
    public String getName() {
        return this.bukkitPlayer.getName();
    }

    @Override
    public double getX() {
        return this.bukkitPlayer.getLocation().getX();
    }

    @Override
    public double getY() {
        return this.bukkitPlayer.getLocation().getY();
    }

    @Override
    public double getZ() {
        return this.bukkitPlayer.getLocation().getZ();
    }

    @Override
    public float getPitch() {
        return this.bukkitPlayer.getLocation().getPitch();
    }

    @Override
    public float getYaw() {
        return this.bukkitPlayer.getLocation().getYaw();
    }

    @Override
    public boolean isOnGround() {
        return this.bukkitPlayer.isOnGround();
    }

    @Override
    public int getPing() {
        if (currentVersion.isNewerThanOrEquals(ServerVersion.V_1_16_5)) {
            return this.bukkitPlayer.getPing();
        }
        return PacketEvents.getAPI().getPlayerManager().getPing(this.bukkitPlayer);
    }

    @Override
    public boolean isGliding() {
        return this.bukkitPlayer.isGliding();
    }

    @Override
    public PlatformWorld getWorld() {
        return BukkitBase.INSTANCE.getPlatform() == Platform.FOLIA ? new FoliaWorld(this.bukkitPlayer.getWorld()) : new SpigotWorld(this.bukkitPlayer.getWorld());
    }

    @Override
    public Vector3d getLocation() {
        Location location = this.bukkitPlayer.getLocation();
        return new Vector3d(location.getX(), location.getY(), location.getZ());
    }

    @Override
    public void sendMessage(@NotNull String s) {
        this.bukkitPlayer.sendMessage(s);
    }

    @Override
    public double getAttackCooldown() {
        if (currentVersion.isNewerThan(ServerVersion.V_1_14_4)) {
            return this.bukkitPlayer.getAttackCooldown();
        }
        try {
            Object entityPlayer = getHandleMethod.invoke((Object)this.bukkitPlayer, new Object[0]);
            return ((Float)getAttackStrengthScaleMethod.invoke(entityPlayer, Float.valueOf(0.5f))).floatValue();
        }
        catch (Exception e) {
            throw new IllegalStateException("This plugin will not work. NMS mapping for getAttackCooldown() failed!");
        }
    }

    @Override
    public boolean isSprinting() {
        return this.bukkitPlayer.isSprinting();
    }

    @Override
    public int getMainHandKnockbackLevel() {
        return this.bukkitPlayer.getInventory().getItemInMainHand().getEnchantmentLevel(Enchantment.KNOCKBACK);
    }

    @Override
    @Nullable
    public Integer getNoDamageTicks() {
        return this.bukkitPlayer.getNoDamageTicks();
    }

    @Override
    public void setVelocity(Vector3d adjustedVelocity) {
        this.bukkitPlayer.setVelocity(new Vector(adjustedVelocity.x, adjustedVelocity.y, adjustedVelocity.z));
    }

    @Override
    public Vector3d getVelocity() {
        Vector bukkitVelocity = this.bukkitPlayer.getVelocity();
        return new Vector3d(bukkitVelocity.getX(), bukkitVelocity.getY(), bukkitVelocity.getZ());
    }

    @Override
    public double getJumpPower() {
        double jumpVelocity = 0.42;
        PotionEffect jumpEffect = this.bukkitPlayer.getPotionEffect(PotionEffectType.JUMP);
        if (jumpEffect != null) {
            int amplifier = jumpEffect.getAmplifier();
            jumpVelocity += (double)((float)(amplifier + 1) * 0.1f);
        }
        return jumpVelocity;
    }

    @Override
    public BoundingBox getBoundingBox() {
        org.bukkit.util.BoundingBox boundingBox = this.bukkitPlayer.getBoundingBox();
        return new BoundingBox(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
    }

    @Override
    @Nullable
    public User getUser() {
        return this.user;
    }

    @Override
    public void setClientBrand(String brand) {
        this.clientBrand = brand;
    }

    @Override
    public String getClientBrand() {
        return this.clientBrand;
    }

    static {
        currentVersion = PacketEvents.getAPI().getServerManager().getVersion();
        try {
            if (currentVersion.isOlderThan(ServerVersion.V_1_15)) {
                Object server = Bukkit.getServer().getClass().getDeclaredMethod("getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
                String nmsPackage = server.getClass().getPackage().getName();
                String bukkitPackage = Bukkit.getServer().getClass().getPackage().getName();
                craftPlayerClass = Class.forName(bukkitPackage + ".entity.CraftPlayer");
                getHandleMethod = craftPlayerClass.getMethod("getHandle", new Class[0]);
                Class<?> entityPlayerClass = Class.forName(nmsPackage + ".EntityPlayer");
                String getAttackStrengthScaleMethodName = "";
                if (currentVersion.isOlderThan(ServerVersion.V_1_13)) {
                    getAttackStrengthScaleMethodName = "n";
                } else if (currentVersion.isOlderThan(ServerVersion.V_1_14)) {
                    getAttackStrengthScaleMethodName = "r";
                } else if (currentVersion.isOlderThan(ServerVersion.V_1_15)) {
                    getAttackStrengthScaleMethodName = "s";
                }
                getAttackStrengthScaleMethod = entityPlayerClass.getMethod(getAttackStrengthScaleMethodName, Float.TYPE);
                getAttackStrengthScaleMethod.setAccessible(true);
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new IllegalStateException("Method of Class required to support this version not found via reflection" + e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Cannot access required methods via reflection to support this version" + e);
        }
    }
}

