/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.sender;

import java.util.UUID;
import me.caseload.knockbacksync.BukkitBase;
import me.caseload.knockbacksync.sender.Sender;
import me.caseload.knockbacksync.sender.SenderFactory;
import me.caseload.knockbacksync.shaded.org.incendo.cloud.SenderMapper;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BukkitSenderFactory
extends SenderFactory<BukkitBase, CommandSender>
implements SenderMapper<CommandSender, Sender> {
    public BukkitSenderFactory(BukkitBase kbSyncBukkitBase) {
        super(kbSyncBukkitBase);
    }

    @Override
    protected String getName(CommandSender sender) {
        if (sender instanceof Player) {
            return sender.getName();
        }
        return "Console";
    }

    @Override
    protected UUID getUniqueId(CommandSender sender) {
        if (sender instanceof Player) {
            return ((Player)sender).getUniqueId();
        }
        return Sender.CONSOLE_UUID;
    }

    @Override
    protected void sendMessage(CommandSender sender, String message) {
        sender.sendMessage(message);
    }

    @Override
    protected boolean hasPermission(CommandSender sender, String node) {
        return sender.hasPermission(node);
    }

    @Override
    protected boolean hasPermission(CommandSender sender, String node, boolean defaultIfUnset) {
        return sender.hasPermission(new Permission(node, defaultIfUnset ? PermissionDefault.TRUE : PermissionDefault.FALSE));
    }

    @Override
    protected void performCommand(CommandSender sender, String command) {
    }

    @Override
    protected boolean isConsole(CommandSender sender) {
        return sender instanceof ConsoleCommandSender || sender instanceof RemoteConsoleCommandSender;
    }

    @Override
    public @NonNull Sender map(@NonNull CommandSender base) {
        return this.wrap(base);
    }

    @Override
    public @NonNull CommandSender reverse(@NonNull Sender mapped) {
        return (CommandSender)this.unwrap(mapped);
    }

    @Override
    public void close() throws Exception {
    }
}

