/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.entity.nautilus;

import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.entity.nautilus.StaticZombieNautilusVariant;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.entity.nautilus.ZombieNautilusVariants;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.mapper.CopyableEntity;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.mapper.DeepComparableEntity;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBT;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTString;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.resources.ResourceLocation;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.util.adventure.AdventureIndexUtil;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import me.caseload.knockbacksync.shaded.net.kyori.adventure.util.Index;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface ZombieNautilusVariant
extends MappedEntity,
CopyableEntity<ZombieNautilusVariant>,
DeepComparableEntity {
    public ModelType getModelType();

    public ResourceLocation getAssetId();

    public static ZombieNautilusVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(ZombieNautilusVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, ZombieNautilusVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static ZombieNautilusVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        String modelTypeString = compound.getStringTagValueOrNull("model");
        ModelType modelType = modelTypeString != null ? ModelType.getByName(modelTypeString) : ModelType.NORMAL;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticZombieNautilusVariant(data, modelType, assetId);
    }

    public static NBT encode(ZombieNautilusVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("model", new NBTString(variant.getModelType().getName()));
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }

    public static enum ModelType {
        NORMAL("normal"),
        WARM("warm");

        private static final Index<String, ModelType> NAME_INDEX;
        private final String name;

        private ModelType(String name) {
            this.name = name;
        }

        public static ModelType getByName(String name) {
            return AdventureIndexUtil.indexValueOrThrow(NAME_INDEX, name);
        }

        public String getName() {
            return this.name;
        }

        static {
            NAME_INDEX = Index.create(ModelType.class, ModelType::getName);
        }
    }
}

