/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.particle;

import java.util.Objects;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBT;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTNumber;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTString;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.particle.data.ParticleData;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.particle.type.ParticleType;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.particle.type.ParticleTypes;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.util.NbtCodec;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.util.NbtCodecException;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.util.NbtMapCodec;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class Particle<T extends ParticleData> {
    public static final NbtCodec<Particle<?>> CODEC = new NbtMapCodec<Particle<?>>(){

        @Override
        public Particle<?> decode(NBTCompound compound, PacketWrapper<?> wrapper) throws NbtCodecException {
            ParticleType<?> type;
            ClientVersion version = wrapper.getServerVersion().toClientVersion();
            ParticleType<?> genericType = type = compound.getOrThrow("type", ParticleTypes.CODEC, wrapper);
            Object data = type.decodeData(compound, version);
            return new Particle(genericType, data);
        }

        @Override
        public void encode(NBTCompound compound, PacketWrapper<?> wrapper, Particle<?> value) throws NbtCodecException {
            ParticleType type = ((Particle)value).type;
            compound.setTag("type", new NBTString(type.getName().toString()));
            type.encodeData(value.getData(), wrapper.getServerVersion().toClientVersion(), compound);
        }
    }.codec();
    private ParticleType<T> type;
    private T data;

    public Particle(ParticleType<T> type, T data) {
        this.type = type;
        this.data = data;
    }

    public Particle(ParticleType<T> type) {
        this(type, ParticleData.emptyData());
    }

    public static Particle<?> read(PacketWrapper<?> wrapper) {
        ParticleType type = wrapper.readMappedEntity(ParticleTypes::getById);
        return new Particle(type, type.readData(wrapper));
    }

    public static <T extends ParticleData> void write(PacketWrapper<?> wrapper, Particle<T> particle) {
        wrapper.writeMappedEntity(particle.type);
        particle.getType().writeData(wrapper, particle.data);
    }

    @Deprecated
    public static Particle<?> decode(NBT nbt, ClientVersion version) {
        NBTCompound compound = (NBTCompound)nbt;
        NBT typeTag = compound.getTagOrThrow("type");
        ParticleType<?> type = typeTag instanceof NBTNumber ? ParticleTypes.getById(version, ((NBTNumber)typeTag).getAsInt()) : ParticleTypes.getByName(((NBTString)typeTag).getValue());
        Object data = type.decodeData(compound, version);
        return new Particle(type, data);
    }

    @Deprecated
    public static <T extends ParticleData> NBT encode(Particle<T> particle, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("type", new NBTString(particle.type.getName().toString()));
        particle.type.encodeData(particle.getData(), version, compound);
        return compound;
    }

    public ParticleType<T> getType() {
        return this.type;
    }

    public void setType(ParticleType<T> type) {
        this.type = type;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Particle)) {
            return false;
        }
        Particle particle = (Particle)obj;
        if (!this.type.equals(particle.type)) {
            return false;
        }
        return this.data.equals(particle.data);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.data);
    }

    public String toString() {
        return "Particle[" + this.type.getName() + ", " + this.data + ']';
    }
}

