/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.util;

import java.util.ArrayList;
import java.util.List;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class WeightedList<T> {
    private final List<Entry<T>> entries;

    public WeightedList() {
        this(new ArrayList<Entry<T>>());
    }

    public WeightedList(List<Entry<T>> entries) {
        this.entries = entries;
    }

    public static <T> WeightedList<T> read(PacketWrapper<?> wrapper, PacketWrapper.Reader<T> reader) {
        List<Entry<T>> entries = wrapper.readList(ew -> Entry.read(wrapper, reader));
        return new WeightedList<T>(entries);
    }

    public static <T> void write(PacketWrapper<?> wrapper, WeightedList<T> list, PacketWrapper.Writer<T> writer) {
        wrapper.writeList(list.entries, (ew, entry) -> Entry.write(ew, entry, writer));
    }

    public List<Entry<T>> getEntries() {
        return this.entries;
    }

    public static final class Entry<T> {
        private final int weight;
        private final T value;

        public Entry(int weight, T value) {
            this.weight = weight;
            this.value = value;
        }

        public static <T> Entry<T> read(PacketWrapper<?> wrapper, PacketWrapper.Reader<T> reader) {
            int weight = wrapper.readVarInt();
            Object value = reader.apply(wrapper);
            return new Entry(weight, value);
        }

        public static <T> void write(PacketWrapper<?> wrapper, Entry<T> entry, PacketWrapper.Writer<T> writer) {
            wrapper.writeVarInt(entry.weight);
            writer.accept(wrapper, entry.value);
        }

        public int getWeight() {
            return this.weight;
        }

        public T getValue() {
            return this.value;
        }
    }
}

