/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.color.AlphaColor;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.color.Color;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBT;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.particle.Particle;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.util.NbtCodec;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.util.NbtCodecException;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.util.NbtCodecs;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.attributes.AmbientSounds;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.attributes.AttributeType;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.attributes.BackgroundMusic;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.attributes.MoonPhase;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.attributes.StaticAttributeType;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.attributes.modifiers.AttributeModifier;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.biome.BiomeEffects;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.util.mappings.VersionedRegistry;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import me.caseload.knockbacksync.shaded.net.kyori.adventure.util.TriState;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class AttributeTypes {
    private static final VersionedRegistry<AttributeType<?>> REGISTRY = new VersionedRegistry("attribute_type");
    public static final AttributeType<Boolean> BOOLEAN = AttributeTypes.define("boolean", NbtCodecs.BOOLEAN, AttributeModifier.BOOLEAN_LIBRARY);
    @ApiStatus.Obsolete
    public static final AttributeType<TriState> TRI_STATE = AttributeTypes.defineUnsynced("tri_state");
    public static final AttributeType<Float> FLOAT = AttributeTypes.define("float", NbtCodecs.FLOAT, AttributeModifier.FLOAT_LIBRARY);
    public static final AttributeType<Float> ANGLE_DEGREES = AttributeTypes.define("angle_degrees", NbtCodecs.FLOAT, AttributeModifier.FLOAT_LIBRARY);
    public static final AttributeType<Color> RGB_COLOR = AttributeTypes.define("rgb_color", NbtCodecs.RGB_COLOR, AttributeModifier.RGB_COLOR_LIBRARY);
    public static final AttributeType<AlphaColor> ARGB_COLOR = AttributeTypes.define("argb_color", NbtCodecs.ARGB_COLOR, AttributeModifier.ARGB_COLOR_LIBRARY);
    public static final AttributeType<MoonPhase> MOON_PHASE = AttributeTypes.define("moon_phase", MoonPhase.CODEC);
    @ApiStatus.Obsolete
    public static final AttributeType<?> ACTIVITY = AttributeTypes.defineUnsynced("activity");
    @ApiStatus.Obsolete
    public static final AttributeType<?> BED_RULE = AttributeTypes.defineUnsynced("bed_rule");
    public static final AttributeType<Particle<?>> PARTICLE = AttributeTypes.define("particle", Particle.CODEC);
    public static final AttributeType<List<BiomeEffects.ParticleSettings>> AMBIENT_PARTICLES = AttributeTypes.define("ambient_particles", BiomeEffects.ParticleSettings.CODEC.applyList());
    public static final AttributeType<BackgroundMusic> BACKGROUND_MUSIC = AttributeTypes.define("background_music", BackgroundMusic.CODEC);
    public static final AttributeType<AmbientSounds> AMBIENT_SOUNDS = AttributeTypes.define("ambient_sounds", AmbientSounds.CODEC);

    private AttributeTypes() {
    }

    @ApiStatus.Internal
    public static <T> AttributeType<T> defineUnsynced(String name) {
        return AttributeTypes.define(name, null, Collections.emptyMap());
    }

    @ApiStatus.Internal
    public static <T> AttributeType<T> define(String name, NbtCodec<T> codec) {
        return AttributeTypes.define(name, codec, Collections.emptyMap());
    }

    @ApiStatus.Internal
    public static <T> AttributeType<T> define(String name, @Nullable NbtCodec<T> codec, Map<AttributeModifier.Operation, AttributeModifier<T, ?>> modifiers) {
        return REGISTRY.define(name, data -> new StaticAttributeType((TypesBuilderData)data, codec, AttributeTypes.createModifierCodec(modifiers)));
    }

    @ApiStatus.Internal
    public static <T> NbtCodec<AttributeModifier<T, ?>> createModifierCodec(final Map<AttributeModifier.Operation, AttributeModifier<T, ?>> modifiers) {
        final HashMap allModifiers = new HashMap(modifiers.size() + 1);
        allModifiers.put(AttributeModifier.Operation.OVERRIDE, AttributeModifier.override());
        allModifiers.putAll(modifiers);
        final HashMap<AttributeModifier, AttributeModifier.Operation> allInverseModifiers = new HashMap<AttributeModifier, AttributeModifier.Operation>(modifiers.size() + 1);
        for (Map.Entry entry : allModifiers.entrySet()) {
            allInverseModifiers.put((AttributeModifier)entry.getValue(), (AttributeModifier.Operation)entry.getKey());
        }
        return new NbtCodec<AttributeModifier<T, ?>>(){

            @Override
            public AttributeModifier<T, ?> decode(NBT nbt, PacketWrapper<?> wrapper) throws NbtCodecException {
                AttributeModifier.Operation op = (AttributeModifier.Operation)AttributeModifier.Operation.CODEC.decode(nbt, wrapper);
                AttributeModifier modifier = (AttributeModifier)allModifiers.get(op);
                if (modifier == null) {
                    throw new NbtCodecException("Unsupported operation " + op + " for " + modifiers);
                }
                return modifier;
            }

            @Override
            public NBT encode(PacketWrapper<?> wrapper, AttributeModifier<T, ?> value) throws NbtCodecException {
                AttributeModifier.Operation op = (AttributeModifier.Operation)allInverseModifiers.get(value);
                if (op == null) {
                    throw new NbtCodecException("Unsupported modifier " + value + " for " + modifiers);
                }
                return AttributeModifier.Operation.CODEC.encode(wrapper, op);
            }
        };
    }

    public static VersionedRegistry<AttributeType<?>> getRegistry() {
        return REGISTRY;
    }

    static {
        REGISTRY.unloadMappings();
    }
}

