/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.attributes.modifiers;

import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.color.AlphaColor;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.color.Color;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.util.NbtCodec;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.util.NbtCodecs;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.attributes.EnvironmentAttribute;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.attributes.modifiers.AttributeModifier;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.attributes.modifiers.BlendToGrayArgument;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface ColorModifier<A>
extends AttributeModifier<Color, A> {
    public static final ColorModifier<AlphaColor> ALPHA_BLEND = Color::blendWith;
    public static final ColorModifier<Color> ADD = Color::plus;
    public static final ColorModifier<Color> SUBTRACT = Color::minus;
    public static final ColorModifier<Color> MULTIPLY = Color::times;
    public static final ColorModifier<BlendToGrayArgument> BLEND_TO_GRAY = new ColorModifier<BlendToGrayArgument>(){

        @Override
        public Color apply(Color value, BlendToGrayArgument arg) {
            return arg.blend(value);
        }

        @Override
        public NbtCodec<BlendToGrayArgument> argumentCodec(EnvironmentAttribute<Color> attribute) {
            return BlendToGrayArgument.CODEC;
        }
    };

    @FunctionalInterface
    public static interface ArgbModifier
    extends ColorModifier<AlphaColor> {
        @Override
        default public NbtCodec<AlphaColor> argumentCodec(EnvironmentAttribute<Color> attribute) {
            return NbtCodecs.ARGB_COLOR;
        }
    }

    @FunctionalInterface
    public static interface RgbModifier
    extends ColorModifier<Color> {
        @Override
        default public NbtCodec<Color> argumentCodec(EnvironmentAttribute<Color> attribute) {
            return NbtCodecs.RGB_COLOR;
        }
    }
}

