/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.attributes.timelines;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBT;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.serializer.SequentialNBTReader;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.attributes.timelines.Timeline;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.resources.ResourceLocation;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.util.mappings.MappingHelper;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.util.mappings.VersionedRegistry;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class Timelines {
    private static final VersionedRegistry<Timeline> REGISTRY = new VersionedRegistry("timeline");
    private static final Map<ResourceLocation, NBTCompound> TIMELINE_DATA = new HashMap<ResourceLocation, NBTCompound>();
    public static final Timeline DAY;
    public static final Timeline EARLY_GAME;
    public static final Timeline MOON;
    public static final Timeline VILLAGER_SCHEDULE;

    private Timelines() {
    }

    @ApiStatus.Internal
    public static Timeline define(String name) {
        return REGISTRY.define(name, data -> {
            NBTCompound dataTag = TIMELINE_DATA.get(data.getName());
            if (dataTag != null) {
                PacketWrapper<?> wrapper = PacketWrapper.createDummyWrapper(ClientVersion.getLatest());
                return (Timeline)((Timeline)Timeline.CODEC.decode(dataTag, wrapper)).copy((TypesBuilderData)data);
            }
            throw new IllegalArgumentException("Can't define timeline " + data.getName() + ", no data found");
        });
    }

    public static VersionedRegistry<Timeline> getRegistry() {
        return REGISTRY;
    }

    static {
        try (SequentialNBTReader.Compound dataTag = MappingHelper.decompress("mappings/data/timeline");){
            dataTag.skipOne();
            for (Map.Entry<String, NBT> entry : (SequentialNBTReader.Compound)dataTag.next().getValue()) {
                ResourceLocation timelineKey = new ResourceLocation(entry.getKey());
                TIMELINE_DATA.put(timelineKey, ((SequentialNBTReader.Compound)entry.getValue()).readFully());
            }
        }
        catch (IOException exception) {
            throw new RuntimeException("Error while reading timeline data", exception);
        }
        DAY = Timelines.define("day");
        EARLY_GAME = Timelines.define("early_game");
        MOON = Timelines.define("moon");
        VILLAGER_SCHEDULE = Timelines.define("villager_schedule");
        REGISTRY.unloadMappings();
    }
}

