/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.biome;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBT;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.serializer.SequentialNBTReader;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.attributes.EnvironmentAttributeMap;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.biome.Biome;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.biome.BiomeEffects;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.biome.StaticBiome;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.resources.ResourceLocation;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.util.mappings.MappingHelper;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.util.mappings.VersionedRegistry;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class Biomes {
    private static final VersionedRegistry<Biome> REGISTRY = new VersionedRegistry("worldgen/biome");
    private static final Map<ResourceLocation, NBTCompound> BIOME_DATA = new HashMap<ResourceLocation, NBTCompound>();
    @ApiStatus.Obsolete
    public static final Biome SNOWY_MOUNTAINS;
    @ApiStatus.Obsolete
    public static final Biome GIANT_SPRUCE_TAIGA;
    @ApiStatus.Obsolete
    public static final Biome BADLANDS_PLATEAU;
    @ApiStatus.Obsolete
    public static final Biome DESERT_HILLS;
    @ApiStatus.Obsolete
    public static final Biome SNOWY_TAIGA_HILLS;
    @ApiStatus.Obsolete
    public static final Biome DARK_FOREST_HILLS;
    @ApiStatus.Obsolete
    public static final Biome MUSHROOM_FIELD_SHORE;
    @ApiStatus.Obsolete
    public static final Biome TALL_BIRCH_FOREST;
    @ApiStatus.Obsolete
    public static final Biome SNOWY_TAIGA_MOUNTAINS;
    @ApiStatus.Obsolete
    public static final Biome TAIGA_MOUNTAINS;
    @ApiStatus.Obsolete
    public static final Biome BAMBOO_JUNGLE_HILLS;
    @ApiStatus.Obsolete
    public static final Biome WOODED_MOUNTAINS;
    @ApiStatus.Obsolete
    public static final Biome TAIGA_HILLS;
    @ApiStatus.Obsolete
    public static final Biome MODIFIED_GRAVELLY_MOUNTAINS;
    @ApiStatus.Obsolete
    public static final Biome MODIFIED_WOODED_BADLANDS_PLATEAU;
    @ApiStatus.Obsolete
    public static final Biome DEEP_WARM_OCEAN;
    @ApiStatus.Obsolete
    public static final Biome GIANT_TREE_TAIGA;
    @ApiStatus.Obsolete
    public static final Biome MODIFIED_JUNGLE;
    @ApiStatus.Obsolete
    public static final Biome TALL_BIRCH_HILLS;
    @ApiStatus.Obsolete
    public static final Biome WOODED_BADLANDS_PLATEAU;
    @ApiStatus.Obsolete
    public static final Biome SNOWY_TUNDRA;
    @ApiStatus.Obsolete
    public static final Biome MOUNTAINS;
    @ApiStatus.Obsolete
    public static final Biome WOODED_HILLS;
    @ApiStatus.Obsolete
    public static final Biome GRAVELLY_MOUNTAINS;
    @ApiStatus.Obsolete
    public static final Biome GIANT_SPRUCE_TAIGA_HILLS;
    @ApiStatus.Obsolete
    public static final Biome MODIFIED_BADLANDS_PLATEAU;
    @ApiStatus.Obsolete
    public static final Biome JUNGLE_HILLS;
    @ApiStatus.Obsolete
    public static final Biome JUNGLE_EDGE;
    @ApiStatus.Obsolete
    public static final Biome MODIFIED_JUNGLE_EDGE;
    @ApiStatus.Obsolete
    public static final Biome SWAMP_HILLS;
    @ApiStatus.Obsolete
    public static final Biome GIANT_TREE_TAIGA_HILLS;
    @ApiStatus.Obsolete
    public static final Biome SHATTERED_SAVANNA;
    @ApiStatus.Obsolete
    public static final Biome MOUNTAIN_EDGE;
    @ApiStatus.Obsolete
    public static final Biome DESERT_LAKES;
    @ApiStatus.Obsolete
    public static final Biome BIRCH_FOREST_HILLS;
    @ApiStatus.Obsolete
    public static final Biome SHATTERED_SAVANNA_PLATEAU;
    @ApiStatus.Obsolete
    public static final Biome STONE_SHORE;
    @ApiStatus.Obsolete
    public static final Biome NETHER;
    public static final Biome BADLANDS;
    public static final Biome BAMBOO_JUNGLE;
    public static final Biome BASALT_DELTAS;
    public static final Biome BEACH;
    public static final Biome BIRCH_FOREST;
    public static final Biome CHERRY_GROVE;
    public static final Biome COLD_OCEAN;
    public static final Biome CRIMSON_FOREST;
    public static final Biome DARK_FOREST;
    public static final Biome DEEP_COLD_OCEAN;
    public static final Biome DEEP_DARK;
    public static final Biome DEEP_FROZEN_OCEAN;
    public static final Biome DEEP_LUKEWARM_OCEAN;
    public static final Biome DEEP_OCEAN;
    public static final Biome DESERT;
    public static final Biome DRIPSTONE_CAVES;
    public static final Biome END_BARRENS;
    public static final Biome END_HIGHLANDS;
    public static final Biome END_MIDLANDS;
    public static final Biome ERODED_BADLANDS;
    public static final Biome FLOWER_FOREST;
    public static final Biome FOREST;
    public static final Biome FROZEN_OCEAN;
    public static final Biome FROZEN_PEAKS;
    public static final Biome FROZEN_RIVER;
    public static final Biome GROVE;
    public static final Biome ICE_SPIKES;
    public static final Biome JAGGED_PEAKS;
    public static final Biome JUNGLE;
    public static final Biome LUKEWARM_OCEAN;
    public static final Biome LUSH_CAVES;
    public static final Biome MANGROVE_SWAMP;
    public static final Biome MEADOW;
    public static final Biome MUSHROOM_FIELDS;
    public static final Biome NETHER_WASTES;
    public static final Biome OCEAN;
    public static final Biome OLD_GROWTH_BIRCH_FOREST;
    public static final Biome OLD_GROWTH_PINE_TAIGA;
    public static final Biome OLD_GROWTH_SPRUCE_TAIGA;
    public static final Biome PLAINS;
    public static final Biome RIVER;
    public static final Biome SAVANNA;
    public static final Biome SAVANNA_PLATEAU;
    public static final Biome SMALL_END_ISLANDS;
    public static final Biome SNOWY_BEACH;
    public static final Biome SNOWY_PLAINS;
    public static final Biome SNOWY_SLOPES;
    public static final Biome SNOWY_TAIGA;
    public static final Biome SOUL_SAND_VALLEY;
    public static final Biome SPARSE_JUNGLE;
    public static final Biome STONY_PEAKS;
    public static final Biome STONY_SHORE;
    public static final Biome SUNFLOWER_PLAINS;
    public static final Biome SWAMP;
    public static final Biome TAIGA;
    public static final Biome THE_END;
    public static final Biome THE_VOID;
    public static final Biome WARM_OCEAN;
    public static final Biome WARPED_FOREST;
    public static final Biome WINDSWEPT_FOREST;
    public static final Biome WINDSWEPT_GRAVELLY_HILLS;
    public static final Biome WINDSWEPT_HILLS;
    public static final Biome WINDSWEPT_SAVANNA;
    public static final Biome WOODED_BADLANDS;
    public static final Biome PALE_GARDEN;

    private Biomes() {
    }

    @ApiStatus.Internal
    public static Biome define(String key) {
        return Biomes.define(key, false);
    }

    @ApiStatus.Internal
    public static Biome define(String key, boolean allowNoData) {
        return REGISTRY.define(key, data -> {
            NBTCompound dataTag = BIOME_DATA.get(data.getName());
            if (dataTag != null) {
                PacketWrapper<?> wrapper = PacketWrapper.createDummyWrapper(ClientVersion.getLatest());
                return (Biome)((Biome)Biome.CODEC.decode(dataTag, wrapper)).copy((TypesBuilderData)data);
            }
            if (allowNoData) {
                BiomeEffects effects = new BiomeEffects(12638463, 4159204, 329011, 7907327, OptionalInt.empty(), OptionalInt.empty(), BiomeEffects.GrassColorModifier.NONE, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
                return new StaticBiome((TypesBuilderData)data, true, 0.8f, Biome.TemperatureModifier.NONE, 0.4f, null, null, null, effects, EnvironmentAttributeMap.EMPTY);
            }
            throw new IllegalArgumentException("Can't define biome " + data.getName() + ", no data found");
        });
    }

    public static VersionedRegistry<Biome> getRegistry() {
        return REGISTRY;
    }

    static {
        try (SequentialNBTReader.Compound dataTag = MappingHelper.decompress("mappings/data/worldgen/biome");){
            dataTag.skipOne();
            for (Map.Entry<String, NBT> entry : (SequentialNBTReader.Compound)dataTag.next().getValue()) {
                ResourceLocation biomeKey = new ResourceLocation(entry.getKey());
                BIOME_DATA.put(biomeKey, ((SequentialNBTReader.Compound)entry.getValue()).readFully());
            }
        }
        catch (IOException exception) {
            throw new RuntimeException("Error while reading biome data", exception);
        }
        SNOWY_MOUNTAINS = Biomes.define("snowy_mountains", true);
        GIANT_SPRUCE_TAIGA = Biomes.define("giant_spruce_taiga", true);
        BADLANDS_PLATEAU = Biomes.define("badlands_plateau", true);
        DESERT_HILLS = Biomes.define("desert_hills", true);
        SNOWY_TAIGA_HILLS = Biomes.define("snowy_taiga_hills", true);
        DARK_FOREST_HILLS = Biomes.define("dark_forest_hills", true);
        MUSHROOM_FIELD_SHORE = Biomes.define("mushroom_field_shore", true);
        TALL_BIRCH_FOREST = Biomes.define("tall_birch_forest", true);
        SNOWY_TAIGA_MOUNTAINS = Biomes.define("snowy_taiga_mountains", true);
        TAIGA_MOUNTAINS = Biomes.define("taiga_mountains", true);
        BAMBOO_JUNGLE_HILLS = Biomes.define("bamboo_jungle_hills", true);
        WOODED_MOUNTAINS = Biomes.define("wooded_mountains", true);
        TAIGA_HILLS = Biomes.define("taiga_hills", true);
        MODIFIED_GRAVELLY_MOUNTAINS = Biomes.define("modified_gravelly_mountains", true);
        MODIFIED_WOODED_BADLANDS_PLATEAU = Biomes.define("modified_wooded_badlands_plateau", true);
        DEEP_WARM_OCEAN = Biomes.define("deep_warm_ocean", true);
        GIANT_TREE_TAIGA = Biomes.define("giant_tree_taiga", true);
        MODIFIED_JUNGLE = Biomes.define("modified_jungle", true);
        TALL_BIRCH_HILLS = Biomes.define("tall_birch_hills", true);
        WOODED_BADLANDS_PLATEAU = Biomes.define("wooded_badlands_plateau", true);
        SNOWY_TUNDRA = Biomes.define("snowy_tundra", true);
        MOUNTAINS = Biomes.define("mountains", true);
        WOODED_HILLS = Biomes.define("wooded_hills", true);
        GRAVELLY_MOUNTAINS = Biomes.define("gravelly_mountains", true);
        GIANT_SPRUCE_TAIGA_HILLS = Biomes.define("giant_spruce_taiga_hills", true);
        MODIFIED_BADLANDS_PLATEAU = Biomes.define("modified_badlands_plateau", true);
        JUNGLE_HILLS = Biomes.define("jungle_hills", true);
        JUNGLE_EDGE = Biomes.define("jungle_edge", true);
        MODIFIED_JUNGLE_EDGE = Biomes.define("modified_jungle_edge", true);
        SWAMP_HILLS = Biomes.define("swamp_hills", true);
        GIANT_TREE_TAIGA_HILLS = Biomes.define("giant_tree_taiga_hills", true);
        SHATTERED_SAVANNA = Biomes.define("shattered_savanna", true);
        MOUNTAIN_EDGE = Biomes.define("mountain_edge", true);
        DESERT_LAKES = Biomes.define("desert_lakes", true);
        BIRCH_FOREST_HILLS = Biomes.define("birch_forest_hills", true);
        SHATTERED_SAVANNA_PLATEAU = Biomes.define("shattered_savanna_plateau", true);
        STONE_SHORE = Biomes.define("stone_shore", true);
        NETHER = Biomes.define("nether", true);
        BADLANDS = Biomes.define("badlands");
        BAMBOO_JUNGLE = Biomes.define("bamboo_jungle");
        BASALT_DELTAS = Biomes.define("basalt_deltas");
        BEACH = Biomes.define("beach");
        BIRCH_FOREST = Biomes.define("birch_forest");
        CHERRY_GROVE = Biomes.define("cherry_grove");
        COLD_OCEAN = Biomes.define("cold_ocean");
        CRIMSON_FOREST = Biomes.define("crimson_forest");
        DARK_FOREST = Biomes.define("dark_forest");
        DEEP_COLD_OCEAN = Biomes.define("deep_cold_ocean");
        DEEP_DARK = Biomes.define("deep_dark");
        DEEP_FROZEN_OCEAN = Biomes.define("deep_frozen_ocean");
        DEEP_LUKEWARM_OCEAN = Biomes.define("deep_lukewarm_ocean");
        DEEP_OCEAN = Biomes.define("deep_ocean");
        DESERT = Biomes.define("desert");
        DRIPSTONE_CAVES = Biomes.define("dripstone_caves");
        END_BARRENS = Biomes.define("end_barrens");
        END_HIGHLANDS = Biomes.define("end_highlands");
        END_MIDLANDS = Biomes.define("end_midlands");
        ERODED_BADLANDS = Biomes.define("eroded_badlands");
        FLOWER_FOREST = Biomes.define("flower_forest");
        FOREST = Biomes.define("forest");
        FROZEN_OCEAN = Biomes.define("frozen_ocean");
        FROZEN_PEAKS = Biomes.define("frozen_peaks");
        FROZEN_RIVER = Biomes.define("frozen_river");
        GROVE = Biomes.define("grove");
        ICE_SPIKES = Biomes.define("ice_spikes");
        JAGGED_PEAKS = Biomes.define("jagged_peaks");
        JUNGLE = Biomes.define("jungle");
        LUKEWARM_OCEAN = Biomes.define("lukewarm_ocean");
        LUSH_CAVES = Biomes.define("lush_caves");
        MANGROVE_SWAMP = Biomes.define("mangrove_swamp");
        MEADOW = Biomes.define("meadow");
        MUSHROOM_FIELDS = Biomes.define("mushroom_fields");
        NETHER_WASTES = Biomes.define("nether_wastes");
        OCEAN = Biomes.define("ocean");
        OLD_GROWTH_BIRCH_FOREST = Biomes.define("old_growth_birch_forest");
        OLD_GROWTH_PINE_TAIGA = Biomes.define("old_growth_pine_taiga");
        OLD_GROWTH_SPRUCE_TAIGA = Biomes.define("old_growth_spruce_taiga");
        PLAINS = Biomes.define("plains");
        RIVER = Biomes.define("river");
        SAVANNA = Biomes.define("savanna");
        SAVANNA_PLATEAU = Biomes.define("savanna_plateau");
        SMALL_END_ISLANDS = Biomes.define("small_end_islands");
        SNOWY_BEACH = Biomes.define("snowy_beach");
        SNOWY_PLAINS = Biomes.define("snowy_plains");
        SNOWY_SLOPES = Biomes.define("snowy_slopes");
        SNOWY_TAIGA = Biomes.define("snowy_taiga");
        SOUL_SAND_VALLEY = Biomes.define("soul_sand_valley");
        SPARSE_JUNGLE = Biomes.define("sparse_jungle");
        STONY_PEAKS = Biomes.define("stony_peaks");
        STONY_SHORE = Biomes.define("stony_shore");
        SUNFLOWER_PLAINS = Biomes.define("sunflower_plains");
        SWAMP = Biomes.define("swamp");
        TAIGA = Biomes.define("taiga");
        THE_END = Biomes.define("the_end");
        THE_VOID = Biomes.define("the_void");
        WARM_OCEAN = Biomes.define("warm_ocean");
        WARPED_FOREST = Biomes.define("warped_forest");
        WINDSWEPT_FOREST = Biomes.define("windswept_forest");
        WINDSWEPT_GRAVELLY_HILLS = Biomes.define("windswept_gravelly_hills");
        WINDSWEPT_HILLS = Biomes.define("windswept_hills");
        WINDSWEPT_SAVANNA = Biomes.define("windswept_savanna");
        WOODED_BADLANDS = Biomes.define("wooded_badlands");
        PALE_GARDEN = Biomes.define("pale_garden");
        BIOME_DATA.clear();
        REGISTRY.unloadMappings();
    }
}

