/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.damagetype;

import java.util.Objects;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.mapper.AbstractMappedEntity;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.damagetype.DamageEffects;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.damagetype.DamageScaling;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.damagetype.DamageType;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.damagetype.DeathMessageType;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class StaticDamageType
extends AbstractMappedEntity
implements DamageType {
    private final String messageId;
    private final DamageScaling scaling;
    private final float exhaustion;
    private final DamageEffects effects;
    private final DeathMessageType deathMessageType;

    @ApiStatus.Internal
    public StaticDamageType(@Nullable TypesBuilderData data, String messageId, DamageScaling scaling, float exhaustion, DamageEffects effects, DeathMessageType deathMessageType) {
        super(data);
        this.messageId = messageId;
        this.scaling = scaling;
        this.exhaustion = exhaustion;
        this.effects = effects;
        this.deathMessageType = deathMessageType;
    }

    @Override
    public DamageType copy(@Nullable TypesBuilderData newData) {
        return new StaticDamageType(newData, this.messageId, this.scaling, this.exhaustion, this.effects, this.deathMessageType);
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public DamageScaling getScaling() {
        return this.scaling;
    }

    @Override
    public float getExhaustion() {
        return this.exhaustion;
    }

    @Override
    public DamageEffects getEffects() {
        return this.effects;
    }

    @Override
    public DeathMessageType getDeathMessageType() {
        return this.deathMessageType;
    }

    @Override
    public boolean deepEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StaticDamageType)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        StaticDamageType that = (StaticDamageType)obj;
        if (Float.compare(that.exhaustion, this.exhaustion) != 0) {
            return false;
        }
        if (!this.messageId.equals(that.messageId)) {
            return false;
        }
        if (this.scaling != that.scaling) {
            return false;
        }
        if (this.effects != that.effects) {
            return false;
        }
        return this.deathMessageType == that.deathMessageType;
    }

    @Override
    public int deepHashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.messageId, this.scaling, Float.valueOf(this.exhaustion), this.effects, this.deathMessageType});
    }

    @Override
    public String toString() {
        return "StaticDamageType{messageId='" + this.messageId + '\'' + ", scaling=" + (Object)((Object)this.scaling) + ", exhaustion=" + this.exhaustion + ", effects=" + (Object)((Object)this.effects) + ", deathMessageType=" + (Object)((Object)this.deathMessageType) + '}';
    }
}

