/*
 * Decompiled with CFR 0.152.
 */
package me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.dimension;

import java.util.OptionalLong;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.mapper.CopyableEntity;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.mapper.DeepComparableEntity;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.mapper.MappedEntityRefSet;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.mapper.MappedEntitySet;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBT;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTByte;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTDouble;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTFloat;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTInt;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTLong;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTNumber;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.util.CodecNameable;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.util.NbtCodec;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.util.NbtCodecException;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.util.NbtCodecs;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.util.NbtMapCodec;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.attributes.EnvironmentAttributeMap;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.attributes.EnvironmentAttributes;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.attributes.timelines.Timeline;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.dimension.DimensionTypeBuilder;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.protocol.world.dimension.DimensionTypeRef;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.resources.ResourceLocation;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.resources.TagKey;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import me.caseload.knockbacksync.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface DimensionType
extends MappedEntity,
CopyableEntity<DimensionType>,
DeepComparableEntity {
    public static final NbtCodec<DimensionType> CODEC = new NbtMapCodec<DimensionType>(){

        @Override
        public DimensionType decode(NBTCompound compound, PacketWrapper<?> wrapper) throws NbtCodecException {
            DimensionTypeBuilder builder = DimensionTypeBuilder.dimensionTypeBuilder();
            ServerVersion version = wrapper.getServerVersion();
            if (version.isNewerThanOrEquals(ServerVersion.V_1_21_11)) {
                builder.setHasFixedTime(compound.getBooleanOr("has_fixed_time", false)).setSkybox(compound.getOr("skybox", Skybox.CODEC, Skybox.OVERWORLD, wrapper)).setCardinalLight(compound.getOr("cardinal_light", CardinalLight.CODEC, CardinalLight.DEFAULT, wrapper)).setAttributes(compound.getOr("attributes", EnvironmentAttributeMap.CODEC, EnvironmentAttributeMap.EMPTY, wrapper)).setTimelines(compound.getOr("timelines", MappedEntitySet::decodeRefSet, MappedEntitySet.createEmpty(), wrapper));
            } else {
                NBTNumber cloudHeightTag;
                Number fixedTimeNum = compound.getNumberTagValueOrNull("fixed_time");
                builder.setFixedTime(fixedTimeNum != null ? Long.valueOf(fixedTimeNum.longValue()) : null).setAttribute(EnvironmentAttributes.GAMEPLAY_WATER_EVAPORATES, compound.getBoolean("ultrawarm")).setNatural(compound.getBoolean("natural")).setBedWorks(compound.getBoolean("bed_works")).setRespawnAnchorWorks(compound.getBoolean("respawn_anchor_works")).setAttribute(EnvironmentAttributes.GAMEPLAY_PIGLINS_ZOMBIFY, !compound.getBoolean("piglin_safe")).setAttribute(EnvironmentAttributes.GAMEPLAY_CAN_START_RAID, compound.getBoolean("has_raids"));
                if (version.isNewerThanOrEquals(ServerVersion.V_1_16_2)) {
                    builder.setEffects(compound.getOrThrow("effects", ResourceLocation.CODEC, wrapper));
                }
                if (version.isNewerThanOrEquals(ServerVersion.V_1_21_6) && (cloudHeightTag = compound.getNumberTagOrNull("cloud_height")) != null) {
                    builder.setAttribute(EnvironmentAttributes.VISUAL_CLOUD_HEIGHT, Float.valueOf(cloudHeightTag.getAsFloat()));
                }
            }
            if (version.isNewerThanOrEquals(ServerVersion.V_1_16_2)) {
                builder.setCoordinateScale(compound.getNumberTagOrThrow("coordinate_scale").getAsDouble());
                if (version.isNewerThanOrEquals(ServerVersion.V_1_17)) {
                    builder.setMinY(compound.getNumberTagOrThrow("min_y").getAsInt());
                    builder.setHeight(compound.getNumberTagOrThrow("height").getAsInt());
                    if (version.isNewerThanOrEquals(ServerVersion.V_1_19)) {
                        builder.setMonsterSpawnLightLevel(compound.getTagOrThrow("monster_spawn_light_level"));
                        builder.setMonsterSpawnBlockLightLimit(compound.getNumberTagOrThrow("monster_spawn_block_light_limit").getAsInt());
                    }
                }
            } else {
                builder.setCoordinateScale(compound.getBoolean("shrunk") ? 8.0 : 1.0);
            }
            return builder.setHasSkylight(compound.getBooleanOrThrow("has_skylight")).setHasCeiling(compound.getBooleanOrThrow("has_ceiling")).setLogicalHeight(compound.getNumberTagValueOrThrow("logical_height").intValue()).setInfiniburn(compound.getOrThrow("infiniburn", TagKey.CODEC, wrapper)).setAmbientLight(compound.getNumberTagValueOrThrow("ambient_light").floatValue()).build();
        }

        @Override
        public void encode(NBTCompound compound, PacketWrapper<?> wrapper, DimensionType value) throws NbtCodecException {
            ServerVersion version = wrapper.getServerVersion();
            if (version.isNewerThanOrEquals(ServerVersion.V_1_21_11)) {
                MappedEntityRefSet<Timeline> timelines;
                EnvironmentAttributeMap env;
                CardinalLight cardinalLight;
                Skybox skybox;
                if (value.hasFixedTime()) {
                    compound.setTag("has_fixed_time", new NBTByte(true));
                }
                if ((skybox = value.getSkybox()) != Skybox.OVERWORLD) {
                    compound.set("skybox", skybox, Skybox.CODEC, wrapper);
                }
                if ((cardinalLight = value.getCardinalLight()) != CardinalLight.DEFAULT) {
                    compound.set("cardinal_light", cardinalLight, CardinalLight.CODEC, wrapper);
                }
                if (!(env = value.getAttributes()).isEmpty()) {
                    compound.set("attributes", env, EnvironmentAttributeMap.CODEC, wrapper);
                }
                if (!(timelines = value.getTimelinesRef()).isEmpty()) {
                    compound.set("timelines", timelines, MappedEntitySet::encodeRefSet, wrapper);
                }
            } else {
                Integer cloudHeight;
                OptionalLong fixedTime = value.getFixedTime();
                if (fixedTime.isPresent()) {
                    compound.setTag("fixed_time", new NBTLong(fixedTime.getAsLong()));
                }
                compound.setTag("ultrawarm", new NBTByte(value.isUltraWarm()));
                compound.setTag("natural", new NBTByte(value.isNatural()));
                compound.setTag("bed_works", new NBTByte(value.isBedWorking()));
                compound.setTag("respawn_anchor_works", new NBTByte(value.isRespawnAnchorWorking()));
                compound.setTag("piglin_safe", new NBTByte(value.isPiglinSafe()));
                compound.setTag("has_raids", new NBTByte(value.hasRaids()));
                if (version.isNewerThanOrEquals(ServerVersion.V_1_16_2)) {
                    compound.set("effects", value.getEffectsLocation(), ResourceLocation.CODEC, wrapper);
                }
                if (version.isNewerThanOrEquals(ServerVersion.V_1_21_6) && (cloudHeight = value.getCloudHeight()) != null) {
                    compound.setTag("cloud_height", new NBTInt(cloudHeight));
                }
            }
            if (version.isNewerThanOrEquals(ServerVersion.V_1_16_2)) {
                compound.setTag("coordinate_scale", new NBTDouble(value.getCoordinateScale()));
                if (version.isNewerThanOrEquals(ServerVersion.V_1_17)) {
                    compound.setTag("min_y", new NBTInt(value.getMinY()));
                    compound.setTag("height", new NBTInt(value.getHeight()));
                    if (version.isNewerThanOrEquals(ServerVersion.V_1_19)) {
                        compound.setTag("monster_spawn_light_level", value.getMonsterSpawnLightLevel());
                        compound.setTag("monster_spawn_block_light_limit", new NBTInt(value.getMonsterSpawnBlockLightLimit()));
                    }
                }
            } else {
                compound.setTag("shrunk", new NBTByte(value.isShrunk()));
            }
            compound.setTag("has_skylight", new NBTByte(value.hasSkyLight()));
            compound.setTag("has_ceiling", new NBTByte(value.hasCeiling()));
            compound.setTag("logical_height", new NBTInt(value.getLogicalHeight()));
            compound.set("infiniburn", value.getInfiniburn(), TagKey.CODEC, wrapper);
            compound.setTag("ambient_light", new NBTFloat(value.getAmbientLight()));
        }
    }.codec();

    public boolean hasFixedTime();

    @ApiStatus.Obsolete
    public OptionalLong getFixedTime();

    public boolean hasSkyLight();

    public boolean hasCeiling();

    @ApiStatus.Obsolete
    public boolean isUltraWarm();

    @ApiStatus.Obsolete
    public boolean isNatural();

    public double getCoordinateScale();

    default public boolean isShrunk() {
        return this.getCoordinateScale() > 1.0;
    }

    @ApiStatus.Obsolete
    public boolean isBedWorking();

    @ApiStatus.Obsolete
    public boolean isRespawnAnchorWorking();

    public int getMinY();

    @Deprecated
    default public int getMinY(ClientVersion version) {
        return this.getMinY();
    }

    public int getHeight();

    default public int getHeight(ClientVersion version) {
        return this.getHeight();
    }

    public int getLogicalHeight();

    @Deprecated
    default public int getLogicalHeight(ClientVersion version) {
        return this.getLogicalHeight();
    }

    public TagKey getInfiniburn();

    @Deprecated
    default public String getInfiniburnTag() {
        return this.getInfiniburn().toString();
    }

    @ApiStatus.Obsolete
    public ResourceLocation getEffectsLocation();

    public float getAmbientLight();

    @ApiStatus.Obsolete
    @Nullable
    public Integer getCloudHeight();

    @ApiStatus.Obsolete
    public boolean isPiglinSafe();

    @ApiStatus.Obsolete
    public boolean hasRaids();

    @ApiStatus.Experimental
    public NBT getMonsterSpawnLightLevel();

    public int getMonsterSpawnBlockLightLimit();

    public Skybox getSkybox();

    public CardinalLight getCardinalLight();

    public EnvironmentAttributeMap getAttributes();

    public MappedEntitySet<Timeline> getTimelines();

    public MappedEntityRefSet<Timeline> getTimelinesRef();

    default public DimensionTypeRef asRef(PacketWrapper<?> wrapper) {
        return new DimensionTypeRef.DirectRef(this, wrapper);
    }

    @Deprecated
    default public DimensionTypeRef asRef(ClientVersion version) {
        return this.asRef(PacketWrapper.createDummyWrapper(version));
    }

    @Deprecated
    public static DimensionType decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        return (DimensionType)((DimensionType)CODEC.decode(nbt, PacketWrapper.createDummyWrapper(version))).copy(data);
    }

    @Deprecated
    public static NBT encode(DimensionType dimensionType, ClientVersion version) {
        return CODEC.encode(PacketWrapper.createDummyWrapper(version), dimensionType);
    }

    public static enum CardinalLight implements CodecNameable
    {
        DEFAULT("default"),
        NETHER("nether");

        public static final NbtCodec<CardinalLight> CODEC;
        private final String name;

        private CardinalLight(String name) {
            this.name = name;
        }

        @Override
        public String getCodecName() {
            return this.name;
        }

        static {
            CODEC = NbtCodecs.forEnum((Enum[])CardinalLight.values());
        }
    }

    public static enum Skybox implements CodecNameable
    {
        NONE("none"),
        OVERWORLD("overworld"),
        END("end");

        public static final NbtCodec<Skybox> CODEC;
        private final String name;

        private Skybox(String name) {
            this.name = name;
        }

        @Override
        public String getCodecName() {
            return this.name;
        }

        static {
            CODEC = NbtCodecs.forEnum((Enum[])Skybox.values());
        }
    }
}

